/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.accesscontrol;

import java.io.File;
import java.io.FileInputStream;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.accesscontrol.AccessControlEntry;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.accesscontrol.PrimaryTypeParser;
import org.apache.sling.feature.cpconverter.accesscontrol.SystemUser;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;

public final class DefaultAclManager
implements AclManager {
    private static final String CONTENT_XML_FILE_NAME = ".content.xml";
    private static final String DEFAULT_TYPE = "sling:Folder";
    private final Set<SystemUser> preProvidedSystemUsers = new LinkedHashSet<SystemUser>();
    private final Set<RepoPath> preProvidedSystemPaths = new HashSet<RepoPath>();
    private final Set<RepoPath> preProvidedPaths = new HashSet<RepoPath>();
    private final Set<SystemUser> systemUsers = new LinkedHashSet<SystemUser>();
    private final Map<String, List<AccessControlEntry>> acls = new HashMap<String, List<AccessControlEntry>>();
    private List<String> nodetypeRegistrationSentences = new LinkedList<String>();
    private Set<String> privileges = new LinkedHashSet<String>();

    @Override
    public boolean addSystemUser(SystemUser systemUser) {
        if (this.preProvidedSystemUsers.add(systemUser)) {
            return this.systemUsers.add(systemUser);
        }
        return false;
    }

    @Override
    public boolean addAcl(String systemUser, AccessControlEntry acl) {
        if (this.getSystemUser(systemUser).isPresent()) {
            this.acls.computeIfAbsent(systemUser, k -> new LinkedList()).add(acl);
            return true;
        }
        return false;
    }

    private void addPath(RepoPath path, Set<RepoPath> paths) {
        RepoPath parent;
        if (this.preProvidedPaths.add(path)) {
            paths.add(path);
        }
        if ((parent = path.getParent()) != null && parent.getSegmentCount() > 0) {
            this.addPath(parent, paths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepoinitExtension(List<VaultPackageAssembler> packageAssemblers, FeaturesManager featureManager) {
        try (Formatter formatter = null;){
            formatter = new Formatter();
            if (!this.privileges.isEmpty()) {
                for (String string : this.privileges) {
                    formatter.format("register privilege %s%n", string);
                }
            }
            for (String string : this.nodetypeRegistrationSentences) {
                formatter.format("%s%n", string);
            }
            for (SystemUser systemUser : this.systemUsers) {
                this.addSystemUserPath(formatter, systemUser.getPath());
                formatter.format("create service user %s with path %s%n", systemUser.getId(), systemUser.getPath());
                List<AccessControlEntry> authorizations = this.acls.remove(systemUser.getId());
                this.addStatements(systemUser, authorizations, packageAssemblers, formatter);
            }
            for (Map.Entry entry : this.acls.entrySet()) {
                Optional<SystemUser> systemUser = this.getSystemUser((String)entry.getKey());
                if (!systemUser.isPresent()) continue;
                List authorizations = (List)entry.getValue();
                this.addStatements(systemUser.get(), authorizations, packageAssemblers, formatter);
            }
            String text = formatter.toString();
            if (!text.isEmpty()) {
                featureManager.addOrAppendRepoInitExtension(text, null);
            }
        }
    }

    private void addStatements(SystemUser systemUser, List<AccessControlEntry> authorizations, List<VaultPackageAssembler> packageAssemblers, Formatter formatter) {
        if (authorizations != null) {
            Iterator<AccessControlEntry> authorizationsIterator = authorizations.iterator();
            while (authorizationsIterator.hasNext()) {
                AccessControlEntry acl = authorizationsIterator.next();
                if (!acl.getPath().startsWith(systemUser.getPath())) continue;
                authorizationsIterator.remove();
            }
        }
        this.addPaths(authorizations, packageAssemblers, formatter);
        DefaultAclManager.addAclStatement(formatter, systemUser.getId(), authorizations);
    }

    private Optional<SystemUser> getSystemUser(String id) {
        for (SystemUser systemUser : this.preProvidedSystemUsers) {
            if (!id.equals(systemUser.getId())) continue;
            return Optional.of(systemUser);
        }
        return Optional.empty();
    }

    private final void addSystemUserPath(Formatter formatter, RepoPath path) {
        if (this.preProvidedSystemPaths.add(path)) {
            formatter.format("create path (rep:AuthorizableFolder) %s%n", path);
        }
    }

    @Override
    public void addNodetypeRegistrationSentence(String nodetypeRegistrationSentence) {
        if (nodetypeRegistrationSentence != null) {
            this.nodetypeRegistrationSentences.add(nodetypeRegistrationSentence);
        }
    }

    @Override
    public void addPrivilege(String privilege) {
        this.privileges.add(privilege);
    }

    @Override
    public void reset() {
        this.systemUsers.clear();
        this.acls.clear();
        this.nodetypeRegistrationSentences.clear();
        this.privileges.clear();
    }

    private void addPaths(List<AccessControlEntry> authorizations, List<VaultPackageAssembler> packageAssemblers, Formatter formatter) {
        if (DefaultAclManager.areEmpty(authorizations)) {
            return;
        }
        TreeSet<RepoPath> paths = new TreeSet<RepoPath>();
        for (AccessControlEntry authorization : authorizations) {
            this.addPath(authorization.getRepositoryPath(), paths);
        }
        for (RepoPath path : paths) {
            String type = DefaultAclManager.computePathType(path, packageAssemblers);
            formatter.format("create path (%s) %s%n", type, path);
        }
    }

    private static String computePathType(RepoPath path, List<VaultPackageAssembler> packageAssemblers) {
        path = new RepoPath(PlatformNameFormat.getPlatformPath((String)path.toString()));
        for (VaultPackageAssembler packageAssembler : packageAssemblers) {
            String string;
            File currentContent;
            File currentDir = packageAssembler.getEntry(path.toString());
            if (!currentDir.exists() || !(currentContent = new File(currentDir, CONTENT_XML_FILE_NAME)).exists()) continue;
            FileInputStream input = new FileInputStream(currentContent);
            try {
                string = (String)new PrimaryTypeParser(DEFAULT_TYPE).parse(input);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("A fatal error occurred while parsing the '" + currentContent + "' file, see nested exceptions: " + e);
                }
            }
            input.close();
            return string;
        }
        return DEFAULT_TYPE;
    }

    private static void addAclStatement(Formatter formatter, String systemUser, List<AccessControlEntry> authorizations) {
        if (authorizations == null || DefaultAclManager.areEmpty(authorizations)) {
            return;
        }
        formatter.format("set ACL for %s%n", systemUser);
        for (AccessControlEntry authorization : authorizations) {
            formatter.format("%s %s on %s", authorization.getOperation(), authorization.getPrivileges(), authorization.getRepositoryPath());
            if (!authorization.getRestrictions().isEmpty()) {
                formatter.format(" restriction(%s)", authorization.getRestrictions().stream().collect(Collectors.joining(",")));
            }
            formatter.format("%n", new Object[0]);
        }
        formatter.format("end%n", new Object[0]);
    }

    private static boolean areEmpty(List<AccessControlEntry> authorizations) {
        return authorizations == null || authorizations.isEmpty();
    }
}

