/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config.validation;

import java.util.List;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationApi;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.FrameworkPropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Operation;
import org.apache.sling.feature.extension.apiregions.api.config.Region;
import org.apache.sling.feature.extension.apiregions.api.config.validation.ConfigurationValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.ConfigurationValidator;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidator;

public class FeatureValidator {
    private final ConfigurationValidator configurationValidator = new ConfigurationValidator();
    private final PropertyValidator propertyValidator = new PropertyValidator();
    private FeatureProvider featureProvider;

    public FeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void setFeatureProvider(FeatureProvider provider) {
        this.featureProvider = provider;
    }

    public FeatureValidationResult validate(Feature feature, ConfigurationApi api) {
        RegionInfo regionInfo;
        FeatureValidationResult result = new FeatureValidationResult();
        if (api == null) {
            throw new IllegalArgumentException();
        }
        for (Configuration config : feature.getConfigurations()) {
            ConfigurationValidationResult cvr;
            ConfigurationValidationResult r;
            ConfigurableEntity desc;
            regionInfo = this.getRegionInfo(feature, config);
            if (regionInfo == null) {
                ConfigurationValidationResult cvr2 = new ConfigurationValidationResult();
                cvr2.getErrors().add("Unable to properly validate configuration, region info cannot be determined");
                result.getConfigurationResults().put(config.getPid(), cvr2);
            } else if (config.isFactoryConfiguration()) {
                desc = api.getFactoryConfigurationDescriptions().get(config.getFactoryPid());
                if (desc != null) {
                    r = this.configurationValidator.validate(config, desc, regionInfo.region);
                    result.getConfigurationResults().put(config.getPid(), r);
                    if (regionInfo.region != Region.INTERNAL) {
                        if (((FactoryConfigurationDescription)desc).getOperations().isEmpty()) {
                            r.getErrors().add("No operations allowed for factory configuration");
                        } else if (regionInfo.isUpdate && !((FactoryConfigurationDescription)desc).getOperations().contains((Object)Operation.UPDATE)) {
                            r.getErrors().add("Updating of factory configuration is not allowed");
                        } else if (!regionInfo.isUpdate && !((FactoryConfigurationDescription)desc).getOperations().contains((Object)Operation.CREATE)) {
                            r.getErrors().add("Creation of factory configuration is not allowed");
                        }
                        if (((FactoryConfigurationDescription)desc).getInternalNames().contains(config.getName())) {
                            r.getErrors().add("Factory configuration with name is not allowed");
                        }
                    }
                } else if (regionInfo.region != Region.INTERNAL && api.getInternalFactoryConfigurations().contains(config.getFactoryPid())) {
                    cvr = new ConfigurationValidationResult();
                    cvr.getErrors().add("Factory configuration is not allowed");
                    result.getConfigurationResults().put(config.getPid(), cvr);
                }
            } else {
                desc = api.getConfigurationDescriptions().get(config.getPid());
                if (desc != null) {
                    r = this.configurationValidator.validate(config, desc, regionInfo.region);
                    result.getConfigurationResults().put(config.getPid(), r);
                } else if (regionInfo.region != Region.INTERNAL && api.getInternalConfigurations().contains(config.getPid())) {
                    cvr = new ConfigurationValidationResult();
                    cvr.getErrors().add("Configuration is not allowed");
                    result.getConfigurationResults().put(config.getPid(), cvr);
                }
            }
            result.getConfigurationResults().computeIfAbsent(config.getPid(), id -> new ConfigurationValidationResult());
        }
        for (String frameworkProperty : feature.getFrameworkProperties().keySet()) {
            regionInfo = this.getRegionInfo(feature, frameworkProperty);
            if (regionInfo == null) {
                PropertyValidationResult pvr = new PropertyValidationResult();
                pvr.getErrors().add("Unable to properly validate framework property, region info cannot be determined");
                result.getFrameworkPropertyResults().put(frameworkProperty, pvr);
            } else {
                PropertyValidationResult pvr;
                FrameworkPropertyDescription fpd = api.getFrameworkPropertyDescriptions().get(frameworkProperty);
                if (fpd != null) {
                    pvr = this.propertyValidator.validate(feature.getFrameworkProperties().get(frameworkProperty), fpd);
                    result.getFrameworkPropertyResults().put(frameworkProperty, pvr);
                } else if (regionInfo.region != Region.INTERNAL && api.getInternalFrameworkProperties().contains(frameworkProperty)) {
                    pvr = new PropertyValidationResult();
                    pvr.getErrors().add("Framework property is not allowed");
                    result.getFrameworkPropertyResults().put(frameworkProperty, pvr);
                }
            }
            result.getFrameworkPropertyResults().computeIfAbsent(frameworkProperty, id -> new PropertyValidationResult());
        }
        return result;
    }

    RegionInfo getRegionInfo(Feature feature, Configuration cfg) {
        FeatureProvider provider = this.getFeatureProvider();
        RegionInfo result = new RegionInfo();
        List list = cfg.getFeatureOrigins();
        if (!list.isEmpty()) {
            boolean global = false;
            for (ArtifactId id : list) {
                Feature f;
                Feature feature2 = f = provider == null ? null : provider.provide(id);
                if (f == null) {
                    return null;
                }
                ConfigurationApi api = ConfigurationApi.getConfigurationApi(f);
                if (api != null && api.getRegion() == Region.INTERNAL) continue;
                global = true;
                break;
            }
            result.region = global ? Region.GLOBAL : Region.INTERNAL;
            result.isUpdate = list.size() > 1;
        } else {
            ConfigurationApi api = ConfigurationApi.getConfigurationApi(feature);
            result.region = api == null || api.getRegion() == null || api.getRegion() == Region.GLOBAL ? Region.GLOBAL : Region.INTERNAL;
            result.isUpdate = false;
        }
        return result;
    }

    RegionInfo getRegionInfo(Feature feature, String frameworkProperty) {
        FeatureProvider provider = this.getFeatureProvider();
        List list = feature.getFeatureOrigins(feature.getFrameworkPropertyMetadata(frameworkProperty));
        boolean global = false;
        for (ArtifactId id : list) {
            Feature found = null;
            if (feature.getId().equals((Object)id)) {
                found = feature;
            } else {
                Feature feature2 = found = provider == null ? null : provider.provide(id);
            }
            if (found == null) {
                return null;
            }
            ConfigurationApi api = ConfigurationApi.getConfigurationApi(found);
            if (api != null && api.getRegion() == Region.INTERNAL) continue;
            global = true;
            break;
        }
        RegionInfo result = new RegionInfo();
        result.region = global ? Region.GLOBAL : Region.INTERNAL;
        result.isUpdate = list.size() > 1;
        return result;
    }

    static final class RegionInfo {
        public Region region;
        public boolean isUpdate;

        RegionInfo() {
        }
    }
}

