/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Hashtable;
import org.apache.felix.cm.json.ConfigurationResource;
import org.apache.felix.cm.json.ConfigurationWriter;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;

public class ConfigurationJSONWriter {
    public static void write(Writer writer, Configurations configs) throws IOException {
        ConfigurationJSONWriter w = new ConfigurationJSONWriter();
        w.writeConfigurations(writer, configs);
    }

    private void writeConfigurations(Writer writer, Configurations configs) throws IOException {
        ConfigurationWriter cfgWriter = org.apache.felix.cm.json.Configurations.buildWriter().build(writer);
        ConfigurationResource rsrc = new ConfigurationResource();
        for (Configuration cfg : configs) {
            Hashtable properties;
            if (cfg.getProperties() instanceof Hashtable && cfg.getProperties().get(":configurator:feature:service.bundleLocation") == null) {
                properties = (Hashtable)cfg.getProperties();
            } else {
                properties = org.apache.felix.cm.json.Configurations.newConfiguration();
                for (String name : Collections.list(cfg.getProperties().keys())) {
                    if (":configurator:feature:service.bundleLocation".equals(name)) continue;
                    properties.put(name, cfg.getProperties().get(name));
                }
            }
            rsrc.getConfigurations().put(cfg.getPid(), properties);
        }
        cfgWriter.writeConfigurationResource(rsrc);
    }
}

