/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config.validation;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Region;
import org.apache.sling.feature.extension.apiregions.api.config.validation.ConfigurationValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidator;

public class ConfigurationValidator {
    public static final List<String> ALLOWED_PROPERTIES = Arrays.asList("service.description", "service.vendor", "service.ranking");
    private final PropertyValidator propertyValidator = new PropertyValidator();

    public ConfigurationValidationResult validate(Configuration config, ConfigurableEntity desc, Region region) {
        ConfigurationValidationResult result = new ConfigurationValidationResult();
        if (config.isFactoryConfiguration()) {
            if (!(desc instanceof FactoryConfigurationDescription)) {
                result.getErrors().add("Factory configuration cannot be validated against non factory configuration description");
            } else {
                this.validateProperties(config, desc, result.getPropertyResults(), region);
            }
        } else if (!(desc instanceof ConfigurationDescription)) {
            result.getErrors().add("Configuration cannot be validated against factory configuration description");
        } else {
            this.validateProperties(config, desc, result.getPropertyResults(), region);
        }
        if (desc.getDeprecated() != null) {
            result.getWarnings().add(desc.getDeprecated());
        }
        return result;
    }

    void validateProperties(Configuration configuration, ConfigurableEntity desc, Map<String, PropertyValidationResult> results, Region region) {
        Dictionary properties = configuration.getConfigurationProperties();
        for (Map.Entry<String, PropertyDescription> propEntry : desc.getPropertyDescriptions().entrySet()) {
            Object value = properties.get(propEntry.getKey());
            PropertyValidationResult result = this.propertyValidator.validate(value, propEntry.getValue());
            results.put(propEntry.getKey(), result);
        }
        Enumeration keyEnum = properties.keys();
        while (keyEnum.hasMoreElements()) {
            String propName = (String)keyEnum.nextElement();
            if (desc.getPropertyDescriptions().containsKey(propName)) continue;
            PropertyValidationResult result = new PropertyValidationResult();
            results.put(propName, result);
            if ("service.ranking".equals(propName)) {
                Object value = properties.get(propName);
                if (value instanceof Integer) continue;
                result.getErrors().add("service.ranking must be of type Integer");
                continue;
            }
            if (ALLOWED_PROPERTIES.contains(propName) || region == Region.INTERNAL) continue;
            result.getErrors().add("Property is not allowed");
        }
    }
}

