/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.Operation;

public class FactoryConfigurationDescription
extends ConfigurableEntity {
    private final Set<Operation> operations = new HashSet<Operation>();
    private final List<String> internalNames = new ArrayList<String>();

    public FactoryConfigurationDescription() {
        this.setDefaults();
    }

    void setDefaults() {
        this.getOperations().add(Operation.CREATE);
        this.getOperations().add(Operation.UPDATE);
    }

    @Override
    public void clear() {
        super.clear();
        this.setDefaults();
        this.internalNames.clear();
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            JsonValue val = this.getAttributes().remove("operations");
            if (val != null) {
                this.getOperations().clear();
                for (JsonValue innerVal : val.asJsonArray()) {
                    String v = this.getString(innerVal).toUpperCase();
                    this.getOperations().add(Operation.valueOf(v));
                }
                if (this.getOperations().isEmpty()) {
                    throw new IOException("Operations must not be empty");
                }
            }
            if ((val = this.getAttributes().remove("internal-names")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    this.getInternalNames().add(this.getString(innerVal));
                }
            }
        }
        catch (IllegalArgumentException | JsonException e) {
            throw new IOException(e);
        }
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    public List<String> getInternalNames() {
        return this.internalNames;
    }

    @Override
    JsonObjectBuilder createJson() throws IOException {
        JsonArrayBuilder arrayBuilder;
        JsonObjectBuilder objBuilder = super.createJson();
        if (!this.getOperations().isEmpty() && this.getOperations().size() != 2) {
            arrayBuilder = Json.createArrayBuilder();
            for (Operation op : this.getOperations()) {
                arrayBuilder.add(op.name());
            }
            objBuilder.add("operations", arrayBuilder);
        }
        if (!this.getInternalNames().isEmpty()) {
            arrayBuilder = Json.createArrayBuilder();
            for (String n : this.getInternalNames()) {
                arrayBuilder.add(n);
            }
            objBuilder.add("internal-names", arrayBuilder);
        }
        return objBuilder;
    }
}

