/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.felix.cm.json.Configurations;

public abstract class AttributeableEntity {
    private final Map<String, JsonValue> attributes = new LinkedHashMap<String, JsonValue>();

    public void clear() {
        this.attributes.clear();
    }

    public JsonObject toJSONObject() throws IOException {
        JsonObjectBuilder objectBuilder = this.createJson();
        return objectBuilder.build();
    }

    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        this.clear();
        try {
            for (Map.Entry entry : jsonObj.entrySet()) {
                this.getAttributes().put((String)entry.getKey(), (JsonValue)entry.getValue());
            }
        }
        catch (IllegalArgumentException | JsonException e) {
            throw new IOException(e);
        }
    }

    public Map<String, JsonValue> getAttributes() {
        return this.attributes;
    }

    JsonObjectBuilder createJson() throws IOException {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, JsonValue> entry : this.getAttributes().entrySet()) {
            objectBuilder.add(entry.getKey(), entry.getValue());
        }
        return objectBuilder;
    }

    String getString(JsonValue jsonValue) {
        Object obj = Configurations.convertToObject((JsonValue)jsonValue);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    String getString(String attributeName) {
        Object obj;
        JsonValue val = this.getAttributes().remove(attributeName);
        if (val != null && (obj = Configurations.convertToObject((JsonValue)val)) != null) {
            return obj.toString();
        }
        return null;
    }

    Number getNumber(String attributeName) throws IOException {
        JsonValue val = this.getAttributes().remove(attributeName);
        if (val != null) {
            Object obj = Configurations.convertToObject((JsonValue)val);
            if (obj instanceof Number) {
                return (Number)obj;
            }
            throw new IOException("Invalid type for number value " + attributeName + " : " + val.getValueType().name());
        }
        return null;
    }

    void setString(JsonObjectBuilder builder, String attributeName, String value) {
        if (value != null) {
            builder.add(attributeName, value);
        }
    }

    int getInteger(String attributeName, int defaultValue) {
        String val = this.getString(attributeName);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return defaultValue;
    }

    boolean getBoolean(String attributeName, boolean defaultValue) throws IOException {
        JsonValue val = this.getAttributes().remove(attributeName);
        if (val != null) {
            Object obj = Configurations.convertToObject((JsonValue)val);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            throw new IOException("Invalid type for boolean value " + attributeName + " : " + val.getValueType().name());
        }
        return defaultValue;
    }
}

