/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.util.Map;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.handlers.SystemUsersEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.VersionResolverContentPackageEntryHandler;
import org.apache.sling.feature.cpconverter.vltpkg.BaseVaultPackageScanner;

public final class RecollectorVaultPackageScanner
extends BaseVaultPackageScanner {
    private final ContentPackage2FeatureModelConverter converter;
    private final EntryHandler[] handlers;

    public RecollectorVaultPackageScanner(ContentPackage2FeatureModelConverter converter, PackageManager packageManager, boolean strictValidation, Map<PackageId, String> subContentPackages) {
        super(packageManager, strictValidation);
        this.converter = converter;
        this.handlers = new EntryHandler[]{new SystemUsersEntryHandler(), new VersionResolverContentPackageEntryHandler(this, subContentPackages)};
    }

    @Override
    protected void onFile(String path, Archive archive, Archive.Entry entry) throws Exception {
        for (EntryHandler handler : this.handlers) {
            if (!handler.matches(path)) continue;
            handler.handle(path, archive, entry, this.converter);
        }
    }
}

