/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.shared;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractJcrNodeParser<O>
extends DefaultHandler {
    private static final String JCR_ROOT = "jcr:root";
    private static final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private final String primaryType;

    public AbstractJcrNodeParser(String primaryType) {
        this.primaryType = primaryType;
    }

    public O parse(InputStream input) throws Exception {
        SAXParser saxParser = saxParserFactory.newSAXParser();
        saxParser.parse(input, (DefaultHandler)this);
        return this.getParsingResult();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (JCR_ROOT.equals(qName)) {
            String primaryType = attributes.getValue("jcr:primaryType");
            this.onJcrRootNode(uri, localName, qName, attributes, primaryType);
        }
    }

    protected final String getPrimaryType() {
        return this.primaryType;
    }

    protected void onJcrRootNode(String uri, String localName, String qName, Attributes attributes, String primaryType) throws SAXException {
        if (this.primaryType.equals(primaryType)) {
            this.onJcrRootElement(uri, localName, qName, attributes);
        }
    }

    protected abstract void onJcrRootElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    protected abstract O getParsingResult();
}

