/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.handlers.EntryHandlersManager;

public class DefaultEntryHandlersManager
implements EntryHandlersManager {
    private final List<EntryHandler> entryHandlers = new LinkedList<EntryHandler>();

    public DefaultEntryHandlersManager() {
        ServiceLoader<EntryHandler> entryHandlersLoader = ServiceLoader.load(EntryHandler.class);
        for (EntryHandler entryHandler : entryHandlersLoader) {
            this.addEntryHandler(entryHandler);
        }
    }

    @Override
    public void addEntryHandler(EntryHandler handler) {
        if (handler != null) {
            this.entryHandlers.add(handler);
        }
    }

    @Override
    public EntryHandler getEntryHandlerByEntryPath(String path) {
        for (EntryHandler entryHandler : this.entryHandlers) {
            if (!entryHandler.matches(path)) continue;
            return entryHandler;
        }
        return null;
    }
}

