/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.filtering;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.sling.feature.cpconverter.filtering.ResourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegexBasedResourceFilter
implements ResourceFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<Pattern> patterns = new LinkedList<Pattern>();

    public void addFilteringPattern(String filteringPattern) {
        Objects.requireNonNull(filteringPattern, "Null pattern to filter resources out is not a valid filtering pattern");
        if (filteringPattern.isEmpty()) {
            throw new IllegalArgumentException("Empty pattern to filter resources out is not a valid filtering pattern");
        }
        this.patterns.add(Pattern.compile(filteringPattern));
    }

    @Override
    public boolean isFilteredOut(String path) {
        for (Pattern pattern : this.patterns) {
            this.logger.debug("Checking if path '{}' matches against '{}' pattern...", (Object)path, (Object)pattern);
            if (pattern.matcher(path).matches()) {
                this.logger.debug("Path '{}' matches against '{}' filtering pattern.", (Object)path, (Object)pattern);
                return true;
            }
            this.logger.debug("Path '{}' does not matches against '{}' filtering pattern.", (Object)path, (Object)pattern);
        }
        this.logger.debug("Path '{}' does not match against any configured filtering pattern.", (Object)path);
        return false;
    }
}

