/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.cli;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

final class ShutDownHook
extends Thread {
    private final long start = System.currentTimeMillis();
    private final Logger logger;

    public ShutDownHook(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void run() {
        this.cleanUp();
        Formatter uptimeFormatter = new Formatter();
        uptimeFormatter.format("Total time:", new Object[0]);
        long uptime = System.currentTimeMillis() - this.start;
        if (uptime < 1000L) {
            uptimeFormatter.format(" %s millisecond%s", uptime, uptime > 1L ? "s" : "");
        } else {
            long minutes;
            long uptimeInSeconds = uptime / 1000L;
            long hours = uptimeInSeconds / 3600L;
            if (hours > 0L) {
                uptimeFormatter.format(" %s hour%s", hours, hours > 1L ? "s" : "");
            }
            if ((minutes = (uptimeInSeconds -= hours * 3600L) / 60L) > 0L) {
                uptimeFormatter.format(" %s minute%s", minutes, minutes > 1L ? "s" : "");
            }
            if ((uptimeInSeconds -= minutes * 60L) > 0L) {
                uptimeFormatter.format(" %s second%s", uptimeInSeconds, uptimeInSeconds > 1L ? "s" : "");
            }
        }
        this.logger.info(uptimeFormatter.toString());
        uptimeFormatter.close();
        this.logger.info("Finished at: {}", (Object)new Date());
        Runtime runtime = Runtime.getRuntime();
        int megaUnit = 0x100000;
        this.logger.info("Final Memory: {}M/{}M", (Object)((runtime.totalMemory() - runtime.freeMemory()) / 0x100000L), (Object)(runtime.totalMemory() / 0x100000L));
        this.logger.info("+-----------------------------------------------------+");
    }

    private void cleanUp() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.logger.info("Cleaning up tmp directories {}, {}", (Object)(tmpDir.getAbsolutePath() + "/sub-content-packages"), (Object)(tmpDir.getAbsolutePath() + "/synthetic-content-packages"));
        try {
            FileUtils.deleteDirectory((File)new File(tmpDir, "synthetic-content-packages"));
            FileUtils.deleteDirectory((File)new File(tmpDir, "sub-content-packages"));
        }
        catch (IOException e) {
            this.logger.error("Error Deleting {}, {}", (Object)(tmpDir + "sub-content-packages"), (Object)(tmpDir + "syntethic-content-packages"));
        }
    }
}

