/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.osgi.framework.Version;

public class CheckApiRegionsBundleExportsImports
implements AnalyserTask {
    private static final String IGNORE_API_REGIONS_CONFIG_KEY = "ignoreAPIRegions";
    private static final String GLOBAL_REGION = "global";
    private static final String NO_REGION = " __NO_REGION__ ";
    private static final String OWN_FEATURE = " __OWN_FEATURE__ ";

    public String getName() {
        return "Bundle Import/Export Check";
    }

    public String getId() {
        return "api-regions-exportsimports";
    }

    private Report getReport(Map<BundleDescriptor, Report> reports, BundleDescriptor info) {
        Report report = reports.get(info);
        if (report == null) {
            report = new Report();
            reports.put(info, report);
        }
        return report;
    }

    private void checkForVersionOnExportedPackages(AnalyserTaskContext ctx, Map<BundleDescriptor, Report> reports) {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            if (info.getExportedPackages() == null) continue;
            for (PackageInfo i : info.getExportedPackages()) {
                if (i.getPackageVersion().compareTo(Version.emptyVersion) != 0) continue;
                this.getReport(reports, (BundleDescriptor)info).exportWithoutVersion.add(i);
            }
        }
    }

    private void checkForVersionOnImportingPackages(AnalyserTaskContext ctx, Map<BundleDescriptor, Report> reports) {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            if (info.getImportedPackages() == null) continue;
            for (PackageInfo i : info.getImportedPackages()) {
                if (i.getVersion() != null || i.getName().startsWith("javax.") || i.getName().startsWith("org.w3c.") || i.getName().startsWith("org.xml.")) continue;
                this.getReport(reports, (BundleDescriptor)info).importWithoutVersion.add(i);
            }
        }
    }

    public void execute(AnalyserTaskContext ctx) throws Exception {
        boolean ignoreAPIRegions = ctx.getConfiguration().getOrDefault(IGNORE_API_REGIONS_CONFIG_KEY, "false").equalsIgnoreCase("true");
        HashMap<BundleDescriptor, Report> reports = new HashMap<BundleDescriptor, Report>();
        this.checkForVersionOnExportedPackages(ctx, reports);
        this.checkForVersionOnImportingPackages(ctx, reports);
        TreeMap<Integer, ArrayList<BundleDescriptor>> bundlesMap = new TreeMap<Integer, ArrayList<BundleDescriptor>>();
        for (BundleDescriptor bi : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            ArrayList<BundleDescriptor> list = (ArrayList<BundleDescriptor>)bundlesMap.get(bi.getArtifact().getStartOrder());
            if (list == null) {
                list = new ArrayList<BundleDescriptor>();
                bundlesMap.put(bi.getArtifact().getStartOrder(), list);
            }
            list.add(bi);
        }
        ArrayList<BundleDescriptor> exportingBundles = new ArrayList<BundleDescriptor>();
        if (ctx.getFrameworkDescriptor() != null) {
            exportingBundles.add(ctx.getFrameworkDescriptor());
        }
        ApiRegions apiRegions = new ApiRegions();
        Feature feature = ctx.getFeature();
        Extensions extensions = feature.getExtensions();
        Extension apiRegionsExtension = extensions.getByName("api-regions");
        if (apiRegionsExtension != null && apiRegionsExtension.getJSONStructure() != null) {
            try {
                apiRegions = ApiRegions.parse((JsonArray)apiRegionsExtension.getJSONStructure());
            }
            catch (IOException e) {
                ctx.reportError("API Regions '" + apiRegionsExtension.getJSON() + "' does not represent a valid JSON 'api-regions': " + e.getMessage());
                return;
            }
        }
        for (Map.Entry entry : bundlesMap.entrySet()) {
            for (BundleDescriptor info : (List)entry.getValue()) {
                if (info.getExportedPackages() == null) continue;
                exportingBundles.add(info);
            }
            for (BundleDescriptor info : (List)entry.getValue()) {
                if (info.getImportedPackages() == null) continue;
                for (PackageInfo pck : info.getImportedPackages()) {
                    Map<BundleDescriptor, Set<String>> candidates = this.getCandidates(exportingBundles, pck, info, apiRegions, ignoreAPIRegions);
                    if (candidates.isEmpty()) {
                        if (pck.isOptional()) {
                            this.getReport(reports, (BundleDescriptor)info).missingExportsForOptional.add(pck);
                            continue;
                        }
                        this.getReport(reports, (BundleDescriptor)info).missingExports.add(pck);
                        continue;
                    }
                    ArrayList<BundleDescriptor> matchingCandidates = new ArrayList<BundleDescriptor>();
                    HashSet<String> exportingRegions = new HashSet<String>();
                    HashSet importingRegions = new HashSet();
                    for (Map.Entry<BundleDescriptor, Set<String>> candidate : candidates.entrySet()) {
                        BundleDescriptor bd = candidate.getKey();
                        if (!bd.isExportingPackage(pck)) continue;
                        Set<String> exRegions = candidate.getValue();
                        if (exRegions.contains(NO_REGION)) {
                            matchingCandidates.add(bd);
                            continue;
                        }
                        if (exRegions.contains(GLOBAL_REGION)) {
                            matchingCandidates.add(bd);
                            continue;
                        }
                        if (exRegions.contains(OWN_FEATURE)) {
                            matchingCandidates.add(bd);
                            continue;
                        }
                        Set<String> imRegions = this.getBundleRegions(info, apiRegions, ignoreAPIRegions);
                        exportingRegions.addAll(exRegions);
                        HashSet<String> regions = new HashSet<String>();
                        for (String region : imRegions) {
                            for (ApiRegion r = apiRegions.getRegionByName(region); r != null; r = r.getParent()) {
                                regions.add(r.getName());
                            }
                        }
                        importingRegions.addAll(regions);
                        regions.retainAll(exRegions);
                        if (regions.isEmpty()) continue;
                        matchingCandidates.add(bd);
                    }
                    if (matchingCandidates.isEmpty()) {
                        if (pck.isOptional()) {
                            this.getReport(reports, (BundleDescriptor)info).missingExportsForOptional.add(pck);
                            continue;
                        }
                        this.getReport(reports, (BundleDescriptor)info).missingExportsWithVersion.add(pck);
                        this.getReport(reports, (BundleDescriptor)info).regionInfo.put(pck, new AbstractMap.SimpleEntry(exportingRegions, importingRegions));
                        continue;
                    }
                    if (matchingCandidates.size() <= 1) continue;
                    this.getReport(reports, (BundleDescriptor)info).exportMatchingSeveral.add(pck);
                }
            }
        }
        boolean errorReported = false;
        for (Map.Entry entry : reports.entrySet()) {
            String key = "Bundle " + ((BundleDescriptor)entry.getKey()).getArtifact().getId().getArtifactId() + ":" + ((BundleDescriptor)entry.getKey()).getArtifact().getId().getVersion();
            if (!((Report)entry.getValue()).importWithoutVersion.isEmpty()) {
                ctx.reportWarning(key + " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).importWithoutVersion, false) + " without specifying a version range.");
            }
            if (!((Report)entry.getValue()).exportWithoutVersion.isEmpty()) {
                ctx.reportWarning(key + " is exporting package(s) " + this.getPackageInfo(((Report)entry.getValue()).importWithoutVersion, false) + " without a version.");
            }
            if (!((Report)entry.getValue()).missingExports.isEmpty()) {
                ctx.reportError(key + " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).missingExports, false) + " in start level " + String.valueOf(((BundleDescriptor)entry.getKey()).getArtifact().getStartOrder()) + " but no bundle is exporting these for that start level.");
                errorReported = true;
            }
            if (((Report)entry.getValue()).missingExportsWithVersion.isEmpty()) continue;
            StringBuilder message = new StringBuilder(key + " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).missingExportsWithVersion, true) + " in start level " + String.valueOf(((BundleDescriptor)entry.getKey()).getArtifact().getStartOrder()) + " but no visible bundle is exporting these for that start level in the required version range.");
            for (Map.Entry<PackageInfo, Map.Entry<Set<String>, Set<String>>> regionInfoEntry : ((Report)entry.getValue()).regionInfo.entrySet()) {
                PackageInfo pkg = regionInfoEntry.getKey();
                Map.Entry<Set<String>, Set<String>> regions = regionInfoEntry.getValue();
                if (regions.getKey().size() <= 0) continue;
                message.append("\n" + pkg.getName() + " is exported in regions " + regions.getKey() + " but it is imported in regions " + regions.getValue());
            }
            ctx.reportError(message.toString());
            errorReported = true;
        }
        if (errorReported && ctx.getFeature().isComplete()) {
            ctx.reportError(ctx.getFeature().getId().toMvnId() + " is marked as 'complete' but has missing imports.");
        }
    }

    private Set<String> getBundleRegions(BundleDescriptor info, ApiRegions regions, boolean ignoreAPIRegions) {
        Set<String> result;
        Set<String> set = result = ignoreAPIRegions ? Collections.emptySet() : Stream.of(info.getArtifact().getFeatureOrigins()).map(regions::getRegionsByFeature).flatMap(Stream::of).map(ApiRegion::getName).collect(Collectors.toSet());
        if (result.isEmpty()) {
            result = new HashSet<String>();
            result.add(NO_REGION);
        }
        return result;
    }

    private String getPackageInfo(List<PackageInfo> pcks, boolean includeVersion) {
        if (pcks.size() == 1) {
            if (includeVersion) {
                return pcks.get(0).toString();
            }
            return pcks.get(0).getName();
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        for (PackageInfo info : pcks) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (includeVersion) {
                sb.append(info.toString());
                continue;
            }
            sb.append(info.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    private Map<BundleDescriptor, Set<String>> getCandidates(List<BundleDescriptor> exportingBundles, PackageInfo pck, BundleDescriptor requestingBundle, ApiRegions apiRegions, boolean ignoreAPIRegions) {
        Set rf;
        Set requestingFeatures = rf = ignoreAPIRegions ? Collections.emptySet() : Stream.of(requestingBundle.getArtifact().getFeatureOrigins()).map(ArtifactId::toMvnId).collect(Collectors.toSet());
        HashMap<BundleDescriptor, Set<String>> candidates = new HashMap<BundleDescriptor, Set<String>>();
        for (BundleDescriptor info : exportingBundles) {
            if (!info.isExportingPackage(pck.getName())) continue;
            Set providingFeatures = ignoreAPIRegions ? Collections.emptySet() : Stream.of(info.getArtifact().getFeatureOrigins()).map(ArtifactId::toMvnId).collect(Collectors.toSet());
            Set intersection = providingFeatures.stream().filter(s -> requestingFeatures.contains(s)).collect(Collectors.toSet());
            if (!intersection.isEmpty()) {
                candidates.put(info, Collections.singleton(OWN_FEATURE));
                continue;
            }
            for (String region : this.getBundleRegions(info, apiRegions, ignoreAPIRegions)) {
                if (!NO_REGION.equals(region) && (apiRegions.getRegionByName(region) == null || apiRegions.getRegionByName(region).getAllExportByName(pck.getName()) == null)) continue;
                HashSet<String> regions = (HashSet<String>)candidates.get(info);
                if (regions == null) {
                    regions = new HashSet<String>();
                    candidates.put(info, regions);
                }
                regions.add(region);
            }
        }
        return candidates;
    }

    public static final class Report {
        public List<PackageInfo> exportWithoutVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> exportMatchingSeveral = new ArrayList<PackageInfo>();
        public List<PackageInfo> importWithoutVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExports = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExportsWithVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExportsForOptional = new ArrayList<PackageInfo>();
        public Map<PackageInfo, Map.Entry<Set<String>, Set<String>>> regionInfo = new HashMap<PackageInfo, Map.Entry<Set<String>, Set<String>>>();
    }
}

