/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.artifacts.InputStreamArtifactWriter;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleEntryHandler
extends AbstractRegexEntryHandler {
    private static final String NAME_GROUP_ID = "groupId";
    private static final String NAME_ARTIFACT_ID = "artifactId";
    private static final String NAME_CLASSIFIER = "classifier";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String JAR_TYPE = "jar";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Pattern pomPropertiesPattern = Pattern.compile("META-INF/maven/[^/]+/[^/]+/pom.properties");

    public BundleEntryHandler() {
        super("/jcr_root/(?:apps|libs)/.+/install(?:\\.([^/]+))?/(?:([0-9]+)/)?.+\\.jar");
    }

    @Override
    public void handle(String path, Archive archive, Archive.Entry entry, ContentPackage2FeatureModelConverter converter) throws Exception {
        String version;
        String artifactId;
        String groupId;
        this.logger.info("Processing bundle {}...", (Object)entry.getName());
        String classifier = null;
        try (JarInputStream jarInput = new JarInputStream(archive.openInputStream(entry));){
            Properties properties = this.readGav(entry.getName(), jarInput);
            Manifest manifest = jarInput.getManifest();
            if (!properties.isEmpty()) {
                groupId = BundleEntryHandler.getCheckedProperty(properties, NAME_GROUP_ID);
                artifactId = BundleEntryHandler.getCheckedProperty(properties, NAME_ARTIFACT_ID);
                version = BundleEntryHandler.getCheckedProperty(properties, "version");
                classifier = properties.getProperty(NAME_CLASSIFIER);
            } else {
                groupId = BundleEntryHandler.getCheckedProperty(manifest, BUNDLE_SYMBOLIC_NAME);
                groupId = groupId.replaceAll(" ", "_");
                artifactId = BundleEntryHandler.getCheckedProperty(manifest, BUNDLE_NAME);
                artifactId = artifactId.replaceAll(" ", "_");
                version = BundleEntryHandler.getCheckedProperty(manifest, BUNDLE_VERSION);
            }
        }
        Matcher matcher = this.getPattern().matcher(path);
        String runMode = null;
        Integer startLevel = null;
        if (!matcher.matches()) {
            throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
        }
        if (StringUtils.isNotBlank((String)matcher.group(1))) {
            runMode = matcher.group(1);
            this.logger.debug("Runmode {} was extracted from path {}", (Object)runMode, (Object)path);
        }
        if (StringUtils.isNotBlank((String)matcher.group(2))) {
            startLevel = Integer.parseInt(matcher.group(2));
            this.logger.debug("Start level {} was extracted from path {}", (Object)startLevel, (Object)path);
        }
        try (InputStream input = archive.openInputStream(entry);){
            ArtifactId id = new ArtifactId(groupId, artifactId, version, classifier, JAR_TYPE);
            converter.getArtifactsDeployer().deploy(new InputStreamArtifactWriter(input), id);
            converter.getFeaturesManager().addArtifact(runMode, id, startLevel);
        }
    }

    protected Properties readGav(String entryName, JarInputStream jarInput) throws IOException {
        JarEntry jarEntry;
        int edx;
        Properties properties = new Properties();
        String bundleName = entryName;
        int idx = bundleName.lastIndexOf(47);
        if (idx >= 0) {
            bundleName = bundleName.substring(idx + 1);
        }
        if ((edx = bundleName.lastIndexOf(46)) > 0) {
            bundleName = bundleName.substring(0, edx);
        }
        while ((jarEntry = jarInput.getNextJarEntry()) != null) {
            String suffix;
            String synthesized;
            String nextEntryName = jarEntry.getName();
            if (!this.pomPropertiesPattern.matcher(nextEntryName).matches()) continue;
            this.logger.info("Reading '{}' bundle GAV from {}...", (Object)bundleName, (Object)nextEntryName);
            properties.load(jarInput);
            String artifactId = properties.getProperty(NAME_ARTIFACT_ID);
            String version = properties.getProperty("version");
            if (artifactId == null || version == null || !bundleName.startsWith(synthesized = artifactId + "-" + version)) continue;
            if (synthesized.length() >= bundleName.length() || (suffix = bundleName.substring(synthesized.length())).length() <= 1 || !suffix.startsWith("-")) break;
            String classifier = suffix.substring(1);
            this.logger.info("Inferred classifier of '" + artifactId + ":" + version + "' to be '" + classifier + "'");
            properties.setProperty(NAME_CLASSIFIER, classifier);
            break;
        }
        return properties;
    }

    private static String getCheckedProperty(Manifest manifest, String name) {
        String property = manifest.getMainAttributes().getValue(name).trim();
        return Objects.requireNonNull(property, "Jar file can not be defined as a valid OSGi bundle without specifying a valid '" + name + "' property.");
    }

    private static String getCheckedProperty(Properties properties, String name) {
        String property = properties.getProperty(name).trim();
        return Objects.requireNonNull(property, "Jar file can not be defined as a valid Maven artifact without specifying a valid '" + name + "' property.");
    }
}

