/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.regex.Matcher;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;

abstract class AbstractConfigurationEntryHandler
extends AbstractRegexEntryHandler {
    private static final String REPOINIT_PID = "org.apache.sling.jcr.repoinit.RepositoryInitializer";

    public AbstractConfigurationEntryHandler(String extension) {
        super("/jcr_root/(?:apps|libs)/.+/config(\\.([^/]+))?/.+\\." + extension);
    }

    @Override
    public final void handle(String path, Archive archive, Archive.Entry entry, ContentPackage2FeatureModelConverter converter) throws Exception {
        Dictionary<String, Object> configurationProperties;
        String id;
        String pid = entry.getName().substring(0, entry.getName().lastIndexOf(46));
        String factoryPid = null;
        int n = pid.indexOf(126);
        if (n == -1) {
            n = pid.indexOf(45);
        }
        if (n > 0) {
            factoryPid = pid.substring(0, n);
            id = factoryPid.concat("~").concat(pid.substring(n + 1));
        } else {
            id = pid;
        }
        this.logger.info("Processing configuration '{}'.", (Object)id);
        try (InputStream input = archive.openInputStream(entry);){
            configurationProperties = this.parseConfiguration(id, input);
        }
        if (configurationProperties == null) {
            this.logger.info("{} entry does not contain a valid OSGi configuration, treating it as a regular resource", (Object)path);
            converter.getMainPackageAssembler().addEntry(path, archive, entry);
            return;
        }
        Matcher matcher = this.getPattern().matcher(path);
        String runMode = null;
        if (!matcher.matches()) {
            throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
        }
        runMode = matcher.group(2);
        if (REPOINIT_PID.equals(factoryPid)) {
            CharSequence[] scripts = (String[])configurationProperties.get("scripts");
            if (scripts != null) {
                String text = String.join((CharSequence)"\n", scripts);
                converter.getFeaturesManager().addOrAppendRepoInitExtension(text);
            }
        } else {
            converter.getFeaturesManager().addConfiguration(runMode, id, configurationProperties);
        }
    }

    protected abstract Dictionary<String, Object> parseConfiguration(String var1, InputStream var2) throws Exception;
}

