/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.features;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.features.RunmodeMapper;
import org.apache.sling.feature.cpconverter.interpolator.SimpleVariablesInterpolator;
import org.apache.sling.feature.cpconverter.interpolator.VariablesInterpolator;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeaturesManager
implements FeaturesManager {
    private static final String JAVA_IO_TMPDIR_PROPERTY = "java.io.tmpdir";
    private static final String CONTENT_PACKAGES = "content-packages";
    private static final String SLING_OSGI_FEATURE_TILE_TYPE = "slingosgifeature";
    private static final String JSON_FILE_EXTENSION = ".json";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Feature> runModes = new HashMap<String, Feature>();
    private final VariablesInterpolator interpolator = new SimpleVariablesInterpolator();
    private final boolean mergeConfigurations;
    private final int bundlesStartOrder;
    private final File featureModelsOutputDirectory;
    private final String artifactIdOverride;
    private final String prefix;
    private final Map<String, String> properties;
    private final List<String> targetAPIRegions = new ArrayList<String>();
    private Feature targetFeature = null;

    public DefaultFeaturesManager() {
        this(true, 20, new File(System.getProperty(JAVA_IO_TMPDIR_PROPERTY)), null, null, null);
    }

    public DefaultFeaturesManager(boolean mergeConfigurations, int bundlesStartOrder, File featureModelsOutputDirectory, String artifactIdOverride, String prefix, Map<String, String> properties) {
        this.mergeConfigurations = mergeConfigurations;
        this.bundlesStartOrder = bundlesStartOrder;
        this.featureModelsOutputDirectory = featureModelsOutputDirectory;
        this.artifactIdOverride = artifactIdOverride;
        this.prefix = prefix;
        this.properties = properties;
    }

    @Override
    public void init(String groupId, String artifactId, String version) {
        this.targetFeature = new Feature(new ArtifactId(groupId, artifactId, version, null, SLING_OSGI_FEATURE_TILE_TYPE));
        this.initAPIRegions(this.targetFeature);
        this.runModes.clear();
    }

    private void initAPIRegions(Feature feature) {
        if (this.targetAPIRegions.size() > 0) {
            Extension apiRegions = new Extension(ExtensionType.JSON, "api-regions", false);
            StringBuilder jsonBuilder = new StringBuilder("[");
            for (String apiRegion : this.targetAPIRegions) {
                if (jsonBuilder.length() > 1) {
                    jsonBuilder.append(',');
                }
                jsonBuilder.append("{\"name\":\"");
                jsonBuilder.append(apiRegion);
                jsonBuilder.append("\",\"exports\":[]}");
            }
            jsonBuilder.append("]");
            apiRegions.setJSON(jsonBuilder.toString());
            feature.getExtensions().add((Object)apiRegions);
        }
    }

    @Override
    public Feature getTargetFeature() {
        return this.targetFeature;
    }

    @Override
    public Feature getRunMode(String runMode) {
        if (this.getTargetFeature() == null) {
            throw new IllegalStateException("Target Feature not initialized yet, please make sure convert() method was invoked first.");
        }
        if (runMode == null) {
            return this.getTargetFeature();
        }
        ArtifactId newId = this.appendRunmode(this.getTargetFeature().getId(), runMode);
        return this.runModes.computeIfAbsent(runMode, k -> {
            Feature f = new Feature(newId);
            this.initAPIRegions(f);
            return f;
        });
    }

    @Override
    public void addArtifact(String runMode, ArtifactId id) {
        this.addArtifact(runMode, id, null);
    }

    @Override
    public void addArtifact(String runMode, ArtifactId id, Integer startOrder) {
        Bundles artifacts;
        Objects.requireNonNull(id, "Artifact can not be attached to a feature without specifying a valid ArtifactId.");
        Artifact artifact = new Artifact(id);
        Feature targetFeature = this.getRunMode(runMode);
        if ("zip".equals(id.getType())) {
            Extensions extensions = targetFeature.getExtensions();
            Extension extension = extensions.getByName(CONTENT_PACKAGES);
            if (extension == null) {
                extension = new Extension(ExtensionType.ARTIFACTS, CONTENT_PACKAGES, true);
                extensions.add((Object)extension);
            }
            artifacts = extension.getArtifacts();
        } else {
            int startOrderForBundle = startOrder != null ? startOrder : this.bundlesStartOrder;
            artifact.setStartOrder(startOrderForBundle);
            artifacts = targetFeature.getBundles();
        }
        artifacts.add(artifact);
    }

    private ArtifactId appendRunmode(ArtifactId id, String runMode) {
        ArtifactId newId;
        if (runMode == null) {
            newId = id;
        } else {
            String classifier = id.getClassifier() != null && !id.getClassifier().isEmpty() ? id.getClassifier() + '-' + runMode : runMode;
            newId = new ArtifactId(id.getGroupId(), id.getArtifactId(), id.getVersion(), classifier, id.getType());
        }
        return newId;
    }

    @Override
    public void addConfiguration(String runMode, String pid, Dictionary<String, Object> configurationProperties) {
        Feature feature = this.getRunMode(runMode);
        Configuration configuration = feature.getConfigurations().getConfiguration(pid);
        if (configuration == null) {
            configuration = new Configuration(pid);
            feature.getConfigurations().add((Object)configuration);
        } else if (!this.mergeConfigurations) {
            throw new IllegalStateException("Configuration '" + pid + "' already defined in Feature Model '" + feature.getId().toMvnId() + "', set the 'mergeConfigurations' flag to 'true' if you want to merge multiple configurations with same PID");
        }
        Enumeration<String> keys = configurationProperties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object[] value = configurationProperties.get(key);
            if (value != null && Collection.class.isInstance(value)) {
                value = ((Collection)value).toArray();
            }
            configuration.getProperties().put(key, value);
        }
    }

    @Override
    public void serialize() throws Exception {
        RunmodeMapper runmodeMapper = RunmodeMapper.open(this.featureModelsOutputDirectory);
        this.serialize(this.targetFeature, null, runmodeMapper);
        if (!this.runModes.isEmpty()) {
            for (Map.Entry<String, Feature> runmodeEntry : this.runModes.entrySet()) {
                String runmode = runmodeEntry.getKey();
                this.serialize(runmodeEntry.getValue(), runmode, runmodeMapper);
            }
        }
        runmodeMapper.save();
    }

    private void serialize(Feature feature, String runMode, RunmodeMapper runmodeMapper) throws Exception {
        StringBuilder fileNameBuilder = new StringBuilder().append(this.prefix != null ? this.prefix : "").append(feature.getId().getArtifactId());
        String classifier = feature.getId().getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            fileNameBuilder.append('-').append(classifier);
        }
        if (this.properties != null) {
            this.properties.put("filename", fileNameBuilder.toString());
        }
        fileNameBuilder.append(JSON_FILE_EXTENSION);
        String fileName = fileNameBuilder.toString();
        File targetFile = new File(this.featureModelsOutputDirectory, fileName);
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        if (this.artifactIdOverride != null && !this.artifactIdOverride.isEmpty()) {
            String interpolatedIdOverride = this.interpolator.interpolate(this.artifactIdOverride, this.properties);
            ArtifactId idOverrride = this.appendRunmode(ArtifactId.parse((String)interpolatedIdOverride), runMode);
            feature = feature.copy(idOverrride);
        }
        this.logger.info("Writing resulting Feature Model '{}' to file '{}'...", (Object)feature.getId(), (Object)targetFile);
        try (FileWriter targetWriter = new FileWriter(targetFile);){
            FeatureJSONWriter.write((Writer)targetWriter, (Feature)feature);
            this.logger.info("'{}' Feature File successfully written!", (Object)targetFile);
            runmodeMapper.addOrUpdate(runMode, fileName);
        }
    }

    public synchronized DefaultFeaturesManager setAPIRegions(List<String> regions) {
        this.targetAPIRegions.clear();
        this.targetAPIRegions.addAll(regions);
        return this;
    }

    @Override
    public void addOrAppendRepoInitExtension(String text) {
        Extension repoInitExtension = this.getTargetFeature().getExtensions().getByName("repoinit");
        if (repoInitExtension == null) {
            repoInitExtension = new Extension(ExtensionType.TEXT, "repoinit", true);
            this.getTargetFeature().getExtensions().add((Object)repoInitExtension);
            repoInitExtension.setText(text);
        } else {
            repoInitExtension.setText(repoInitExtension.getText() + "\n " + text);
        }
    }
}

