/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.Text;

public class SubPackageFilterArchive
implements Archive {
    private final Archive base;

    public SubPackageFilterArchive(Archive base) {
        this.base = base;
    }

    @Override
    public void open(boolean strict) throws IOException {
        this.base.open(strict);
    }

    @Override
    @CheckForNull
    public InputStream openInputStream(@Nullable Archive.Entry entry) throws IOException {
        return this.base.openInputStream(entry);
    }

    @Override
    @CheckForNull
    public VaultInputSource getInputSource(@Nullable Archive.Entry entry) throws IOException {
        return this.base.getInputSource(entry);
    }

    @Override
    @CheckForNull
    public Archive.Entry getJcrRoot() throws IOException {
        return new FilterEntry(this.base.getJcrRoot(), 1L);
    }

    @Override
    @Nonnull
    public Archive.Entry getRoot() throws IOException {
        return new FilterEntry(this.base.getRoot(), 0L);
    }

    @Override
    @Nonnull
    public MetaInf getMetaInf() {
        return this.base.getMetaInf();
    }

    @Override
    @CheckForNull
    public Archive.Entry getEntry(@Nonnull String path) throws IOException {
        if (path.length() == 0 || "/".equals(path)) {
            return this.getRoot();
        }
        if ("/jcr_root".equals(path)) {
            return this.getJcrRoot();
        }
        if ("/jcr_root/etc".equals(path)) {
            return new FilterEntry(this.base.getEntry(path), 2L);
        }
        if (Text.isDescendantOrEqual("/jcr_root/etc/packages", path)) {
            return null;
        }
        return this.base.getEntry(path);
    }

    @Override
    @CheckForNull
    public Archive getSubArchive(@Nonnull String root, boolean asJcrRoot) throws IOException {
        return this.base.getSubArchive(root, asJcrRoot);
    }

    @Override
    public void close() {
        this.base.close();
    }

    public List<Archive.Entry> getSubPackageEntries() throws IOException {
        LinkedList<Archive.Entry> entries = new LinkedList<Archive.Entry>();
        Archive.Entry folder = this.base.getEntry("/jcr_root/etc/packages");
        if (folder != null) {
            this.findSubPackageEntries(entries, folder);
        }
        return entries;
    }

    private void findSubPackageEntries(@Nonnull List<Archive.Entry> entries, @Nonnull Archive.Entry folder) {
        for (Archive.Entry entry : folder.getChildren()) {
            String name = entry.getName();
            if (entry.isDirectory()) {
                if (".snapshot".equals(name)) continue;
                this.findSubPackageEntries(entries, entry);
                continue;
            }
            if (!name.endsWith(".zip")) continue;
            entries.add(entry);
        }
    }

    private final class FilterEntry
    implements Archive.Entry {
        private final Archive.Entry base;
        private final long level;

        private FilterEntry(Archive.Entry base, long level) {
            this.base = base;
            this.level = level;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.base.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.base.isDirectory();
        }

        private Archive.Entry filterChild(Archive.Entry e) {
            if (this.level == 0L && "jcr_root".equals(e.getName())) {
                return new FilterEntry(e, 1L);
            }
            if (this.level == 1L && "etc".equals(e.getName())) {
                return new FilterEntry(e, 2L);
            }
            if (this.level == 2L && "packages".equals(e.getName())) {
                return null;
            }
            return e;
        }

        @Override
        @Nonnull
        public Collection<? extends Archive.Entry> getChildren() {
            Collection<? extends Archive.Entry> children = this.base.getChildren();
            ArrayList<Archive.Entry> ret = new ArrayList<Archive.Entry>(children.size());
            for (Archive.Entry entry : children) {
                Archive.Entry entry2 = this.filterChild(entry);
                if (entry2 == null) continue;
                ret.add(entry2);
            }
            return ret;
        }

        @Override
        @CheckForNull
        public Archive.Entry getChild(@Nonnull String name) {
            return this.filterChild(this.base.getChild(name));
        }
    }
}

