/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.impl.felix.utils.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.feature.io.impl.felix.utils.version.VersionRange;

public class SimpleFilter {
    public static final int MATCH_ALL = 0;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    public static final int EQ = 4;
    public static final int LTE = 5;
    public static final int GTE = 6;
    public static final int SUBSTRING = 7;
    public static final int PRESENT = 8;
    public static final int APPROX = 9;
    private static final ConcurrentHashMap<String, String> COMMON_STRINGS;
    public static final SimpleFilter MATCH_ALL_FILTER;
    private final String name;
    private final Object value;
    private final int op;

    SimpleFilter(String name, Object value, int op) {
        this.name = SimpleFilter.reuseCommonString(name);
        this.value = value;
        this.op = op;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public int getOperation() {
        return this.op;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private void toString(StringBuilder sb) {
        switch (this.op) {
            case 1: {
                sb.append("(&");
                SimpleFilter.toString(sb, (List)this.value);
                sb.append(")");
                break;
            }
            case 2: {
                sb.append("(|");
                SimpleFilter.toString(sb, (List)this.value);
                sb.append(")");
                break;
            }
            case 3: {
                sb.append("(!");
                SimpleFilter.toString(sb, (List)this.value);
                sb.append(")");
                break;
            }
            case 4: {
                sb.append("(").append(this.name).append("=");
                SimpleFilter.toEncodedString(sb, this.value);
                sb.append(")");
                break;
            }
            case 5: {
                sb.append("(").append(this.name).append("<=");
                SimpleFilter.toEncodedString(sb, this.value);
                sb.append(")");
                break;
            }
            case 6: {
                sb.append("(").append(this.name).append(">=");
                SimpleFilter.toEncodedString(sb, this.value);
                sb.append(")");
                break;
            }
            case 7: {
                sb.append("(").append(this.name).append("=");
                SimpleFilter.unparseSubstring(sb, (List)this.value);
                sb.append(")");
                break;
            }
            case 8: {
                sb.append("(").append(this.name).append("=*)");
                break;
            }
            case 9: {
                sb.append("(").append(this.name).append("~=");
                SimpleFilter.toEncodedString(sb, this.value);
                sb.append(")");
                break;
            }
            case 0: {
                sb.append("(*)");
            }
        }
    }

    private static String reuseCommonString(String str) {
        if (str != null) {
            String r = COMMON_STRINGS.get(str);
            return r != null ? r : str;
        }
        return null;
    }

    private static void toString(StringBuilder sb, List<?> list) {
        for (Object o : list) {
            SimpleFilter sf = (SimpleFilter)o;
            sf.toString(sb);
        }
    }

    private static String toDecodedString(String s, int startIdx, int endIdx) {
        StringBuilder sb = null;
        boolean escaped = false;
        for (int i = startIdx; i < endIdx; ++i) {
            char c = s.charAt(i);
            if (!escaped && c == '\\') {
                sb = new StringBuilder(endIdx - startIdx);
                sb.append(s, startIdx, i);
                escaped = true;
                continue;
            }
            escaped = false;
            if (sb == null) continue;
            sb.append(c);
        }
        return sb != null ? sb.toString() : s.substring(startIdx, endIdx);
    }

    private static void toEncodedString(StringBuilder sb, Object o) {
        if (o instanceof String) {
            String s = (String)o;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\' || c == '(' || c == ')' || c == '*') {
                    sb.append('\\');
                }
                sb.append(c);
            }
        } else {
            sb.append(o);
        }
    }

    public static SimpleFilter parse(String filter) {
        int idx = SimpleFilter.skipWhitespace(filter, 0);
        if (filter == null || filter.length() == 0 || idx >= filter.length()) {
            throw new IllegalArgumentException("Null or empty filter.");
        }
        if (filter.charAt(idx) != '(') {
            throw new IllegalArgumentException("Missing opening parenthesis: " + filter);
        }
        SimpleFilter sf = null;
        LinkedList<Object> stack = new LinkedList<Object>();
        boolean isEscaped = false;
        while (idx < filter.length()) {
            if (sf != null) {
                throw new IllegalArgumentException("Only one top-level operation allowed: " + filter);
            }
            if (!isEscaped && filter.charAt(idx) == '(') {
                if (filter.charAt(idx = SimpleFilter.skipWhitespace(filter, idx + 1)) == '&') {
                    int peek = SimpleFilter.skipWhitespace(filter, idx + 1);
                    if (filter.charAt(peek) == '(') {
                        idx = peek - 1;
                        stack.addFirst(new SimpleFilter(null, new ArrayList(2), 1));
                    } else {
                        stack.addFirst(idx);
                    }
                } else if (filter.charAt(idx) == '|') {
                    int peek = SimpleFilter.skipWhitespace(filter, idx + 1);
                    if (filter.charAt(peek) == '(') {
                        idx = peek - 1;
                        stack.addFirst(new SimpleFilter(null, new ArrayList(2), 2));
                    } else {
                        stack.addFirst(idx);
                    }
                } else if (filter.charAt(idx) == '!') {
                    int peek = SimpleFilter.skipWhitespace(filter, idx + 1);
                    if (filter.charAt(peek) == '(') {
                        idx = peek - 1;
                        stack.addFirst(new SimpleFilter(null, new ArrayList(1), 3));
                    } else {
                        stack.addFirst(idx);
                    }
                } else {
                    stack.addFirst(idx);
                }
            } else if (!isEscaped && filter.charAt(idx) == ')') {
                Object top = stack.removeFirst();
                Object next = stack.peekFirst();
                if (top instanceof SimpleFilter) {
                    if (next instanceof SimpleFilter) {
                        ((List)((SimpleFilter)next).value).add(top);
                    } else {
                        sf = (SimpleFilter)top;
                    }
                } else if (next instanceof SimpleFilter) {
                    ((List)((SimpleFilter)next).value).add(SimpleFilter.subfilter(filter, (Integer)top, idx));
                } else {
                    sf = SimpleFilter.subfilter(filter, (Integer)top, idx);
                }
            } else {
                isEscaped = !isEscaped && filter.charAt(idx) == '\\';
            }
            idx = SimpleFilter.skipWhitespace(filter, idx + 1);
        }
        if (sf == null) {
            throw new IllegalArgumentException("Missing closing parenthesis: " + filter);
        }
        return sf;
    }

    private static SimpleFilter subfilter(String filter, int startIdx, int endIdx) {
        int op;
        char c;
        int attrEndIdx = startIdx;
        for (int i = 0; i < endIdx - startIdx && "=<>~".indexOf(c = filter.charAt(startIdx + i)) < 0; ++i) {
            if (Character.isWhitespace(c)) continue;
            attrEndIdx = startIdx + i + 1;
        }
        if (attrEndIdx == startIdx) {
            throw new IllegalArgumentException("Missing attribute name: " + filter.substring(startIdx, endIdx));
        }
        String attr = filter.substring(startIdx, attrEndIdx);
        startIdx = SimpleFilter.skipWhitespace(filter, attrEndIdx);
        switch (filter.charAt(startIdx)) {
            case '=': {
                op = 4;
                ++startIdx;
                break;
            }
            case '<': {
                if (filter.charAt(startIdx + 1) != '=') {
                    throw new IllegalArgumentException("Unknown operator: " + filter.substring(startIdx, endIdx));
                }
                op = 5;
                startIdx += 2;
                break;
            }
            case '>': {
                if (filter.charAt(startIdx + 1) != '=') {
                    throw new IllegalArgumentException("Unknown operator: " + filter.substring(startIdx, endIdx));
                }
                op = 6;
                startIdx += 2;
                break;
            }
            case '~': {
                if (filter.charAt(startIdx + 1) != '=') {
                    throw new IllegalArgumentException("Unknown operator: " + filter.substring(startIdx, endIdx));
                }
                op = 9;
                startIdx += 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + filter.substring(startIdx, endIdx));
            }
        }
        Object value = SimpleFilter.toDecodedString(filter, startIdx, endIdx);
        if (op == 4) {
            String valueStr = filter.substring(startIdx, endIdx);
            List<String> values = SimpleFilter.parseSubstring(valueStr);
            if (values.size() == 2 && values.get(0).length() == 0 && values.get(1).length() == 0) {
                op = 8;
            } else if (values.size() > 1) {
                op = 7;
                value = values;
            }
        }
        return new SimpleFilter(attr, value, op);
    }

    public static List<String> parseSubstring(String value) {
        int length = value.length();
        boolean isSimple = true;
        for (int idx = 0; idx < length; ++idx) {
            char c = value.charAt(idx);
            if (c != '*' && c != '\\') continue;
            isSimple = false;
            break;
        }
        if (isSimple) {
            return Collections.singletonList(value);
        }
        StringBuilder ss = new StringBuilder();
        boolean wasStar = false;
        boolean leftstar = false;
        boolean rightstar = false;
        int idx = 0;
        ArrayList<String> pieces = new ArrayList<String>(2);
        boolean escaped = false;
        while (true) {
            if (idx >= length) {
                if (wasStar) {
                    rightstar = true;
                    break;
                }
                pieces.add(ss.toString());
                break;
            }
            char c = value.charAt(idx++);
            if (!escaped && c == '*') {
                if (wasStar) continue;
                if (ss.length() > 0) {
                    pieces.add(ss.toString());
                }
                ss.setLength(0);
                if (pieces.isEmpty()) {
                    leftstar = true;
                }
                wasStar = true;
                continue;
            }
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            escaped = false;
            wasStar = false;
            ss.append(c);
        }
        ss.setLength(0);
        if (leftstar || rightstar || pieces.size() > 1) {
            if (rightstar) {
                pieces.add("");
            }
            if (leftstar) {
                pieces.add(0, "");
            }
        }
        return pieces;
    }

    public static void unparseSubstring(StringBuilder sb, List<?> pieces) {
        for (int i = 0; i < pieces.size(); ++i) {
            if (i > 0) {
                sb.append("*");
            }
            SimpleFilter.toEncodedString(sb, pieces.get(i));
        }
    }

    public static boolean compareSubstring(List<String> pieces, String s) {
        boolean result = true;
        int len = pieces.size();
        if (len == 1) {
            return s.equals(pieces.get(0));
        }
        int index = 0;
        for (int i = 0; i < len; ++i) {
            String piece = pieces.get(i);
            if (i == 0 && !s.startsWith(piece)) {
                result = false;
                break;
            }
            if (i == len - 1) {
                result = s.endsWith(piece) && s.length() >= index + piece.length();
                break;
            }
            if (i > 0 && i < len - 1 && (index = s.indexOf(piece, index)) < 0) {
                result = false;
                break;
            }
            index += piece.length();
        }
        return result;
    }

    private static int skipWhitespace(String s, int startIdx) {
        int len = s.length();
        while (startIdx < len && Character.isWhitespace(s.charAt(startIdx))) {
            ++startIdx;
        }
        return startIdx;
    }

    public static SimpleFilter convert(Map<String, Object> attrs) {
        ArrayList<SimpleFilter> filters = new ArrayList<SimpleFilter>(attrs.size());
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            if (entry.getValue() instanceof VersionRange) {
                SimpleFilter not;
                SimpleFilter val;
                VersionRange vr = (VersionRange)entry.getValue();
                if (!vr.isOpenFloor()) {
                    filters.add(new SimpleFilter(entry.getKey(), vr.getFloor().toString(), 6));
                } else {
                    val = new SimpleFilter(entry.getKey(), vr.getFloor().toString(), 5);
                    not = new SimpleFilter(null, Collections.singletonList(val), 3);
                    filters.add(not);
                }
                if (vr.getCeiling() == null) continue;
                if (!vr.isOpenCeiling()) {
                    filters.add(new SimpleFilter(entry.getKey(), vr.getCeiling().toString(), 5));
                    continue;
                }
                if (vr.getCeiling().equals((Object)VersionRange.INFINITE_VERSION)) continue;
                val = new SimpleFilter(entry.getKey(), vr.getCeiling().toString(), 6);
                not = new SimpleFilter(null, Collections.singletonList(val), 3);
                filters.add(not);
                continue;
            }
            List<String> values = SimpleFilter.parseSubstring(entry.getValue().toString());
            if (values.size() > 1) {
                filters.add(new SimpleFilter(entry.getKey(), values, 7));
                continue;
            }
            filters.add(new SimpleFilter(entry.getKey(), values.get(0), 4));
        }
        switch (filters.size()) {
            case 0: {
                return MATCH_ALL_FILTER;
            }
            case 1: {
                return (SimpleFilter)filters.get(0);
            }
        }
        return new SimpleFilter(null, filters, 1);
    }

    static {
        ConcurrentHashMap<String, String> s = new ConcurrentHashMap<String, String>(8);
        s.put("optional", "optional");
        s.put("osgi.ee", "osgi.ee");
        s.put("resolution", "resolution");
        s.put("uses", "uses");
        s.put("version", "version");
        COMMON_STRINGS = s;
        MATCH_ALL_FILTER = new SimpleFilter(null, null, 0);
    }
}

