/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.CyclicDependencyException;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.acl.AclManager;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.FileArtifactWriter;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.filtering.ResourceFilter;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.handlers.EntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.NodeTypesEntryHandler;
import org.apache.sling.feature.cpconverter.vltpkg.BaseVaultPackageScanner;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.apache.sling.feature.cpconverter.vltpkg.RecollectorVaultPackageScanner;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageUtils;

public class ContentPackage2FeatureModelConverter
extends BaseVaultPackageScanner {
    public static final String ZIP_TYPE = "zip";
    public static final String PACKAGE_CLASSIFIER = "cp2fm-converted";
    private static final String DEFEAULT_VERSION = "0.0.0";
    private final Map<PackageId, String> subContentPackages = new HashMap<PackageId, String>();
    private final List<VaultPackageAssembler> assemblers = new LinkedList<VaultPackageAssembler>();
    private final Map<PackageId, Set<Dependency>> mutableContentsIds = new LinkedHashMap<PackageId, Set<Dependency>>();
    private EntryHandlersManager handlersManager;
    private AclManager aclManager;
    private FeaturesManager featuresManager;
    private ResourceFilter resourceFilter;
    private ArtifactsDeployer artifactsDeployer;
    private VaultPackageAssembler mainPackageAssembler = null;
    private RecollectorVaultPackageScanner recollectorVaultPackageScanner;
    private PackagesEventsEmitter emitter;
    private boolean failOnMixedPackages = false;
    private boolean dropContent = false;

    public ContentPackage2FeatureModelConverter() {
        this(false);
    }

    public ContentPackage2FeatureModelConverter(boolean strictValidation) {
        super(strictValidation);
        this.recollectorVaultPackageScanner = new RecollectorVaultPackageScanner(this, this.packageManager, strictValidation, this.subContentPackages);
    }

    public ContentPackage2FeatureModelConverter setEntryHandlersManager(EntryHandlersManager handlersManager) {
        this.handlersManager = handlersManager;
        return this;
    }

    public FeaturesManager getFeaturesManager() {
        return this.featuresManager;
    }

    public ContentPackage2FeatureModelConverter setFeaturesManager(FeaturesManager featuresManager) {
        this.featuresManager = featuresManager;
        return this;
    }

    public ContentPackage2FeatureModelConverter setResourceFilter(ResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
        return this;
    }

    public ArtifactsDeployer getArtifactsDeployer() {
        return this.artifactsDeployer;
    }

    public ContentPackage2FeatureModelConverter setBundlesDeployer(ArtifactsDeployer bundlesDeployer) {
        this.artifactsDeployer = bundlesDeployer;
        return this;
    }

    public AclManager getAclManager() {
        return this.aclManager;
    }

    public ContentPackage2FeatureModelConverter setAclManager(AclManager aclManager) {
        this.aclManager = aclManager;
        return this;
    }

    public VaultPackageAssembler getMainPackageAssembler() {
        return this.mainPackageAssembler;
    }

    public ContentPackage2FeatureModelConverter setEmitter(PackagesEventsEmitter emitter) {
        this.emitter = emitter;
        return this;
    }

    public ContentPackage2FeatureModelConverter setDropContent(boolean dropContent) {
        this.dropContent = dropContent;
        return this;
    }

    public ContentPackage2FeatureModelConverter setFailOnMixedPackages(boolean failOnMixedPackages) {
        this.failOnMixedPackages = failOnMixedPackages;
        return this;
    }

    public void convert(File ... contentPackages) throws Exception {
        Objects.requireNonNull(contentPackages, "Null content-package(s) can not be converted.");
        this.secondPass(this.firstPass(contentPackages));
    }

    protected Collection<VaultPackage> firstPass(File ... contentPackages) throws Exception {
        LinkedHashMap<PackageId, VaultPackage> idFileMap = new LinkedHashMap<PackageId, VaultPackage>();
        ConcurrentHashMap<PackageId, VaultPackage> idPackageMapping = new ConcurrentHashMap<PackageId, VaultPackage>();
        for (File contentPackage : contentPackages) {
            Objects.requireNonNull(contentPackage, "Null content-package can not be converted.");
            if (!contentPackage.exists() || !contentPackage.isFile()) {
                throw new IllegalArgumentException("File " + contentPackage + " does not exist or it is a directory");
            }
            this.logger.info("Reading content-package '{}'...", (Object)contentPackage);
            VaultPackage pack = this.open(contentPackage);
            idPackageMapping.put(pack.getId(), pack);
            this.recollectorVaultPackageScanner.traverse(pack);
            this.logger.info("content-package '{}' successfully read!", (Object)contentPackage);
        }
        this.logger.info("Ordering input content-package(s) {}...", idPackageMapping.keySet());
        for (VaultPackage pack : idPackageMapping.values()) {
            this.orderDependencies(idFileMap, idPackageMapping, pack, new HashSet<PackageId>());
        }
        this.logger.info("New content-package(s) order: {}", idFileMap.keySet());
        return idFileMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondPass(Collection<VaultPackage> orderedContentPackages) throws Exception {
        this.emitter.start();
        for (VaultPackage vaultPackage : orderedContentPackages) {
            try {
                this.emitter.startPackage(vaultPackage);
                this.mainPackageAssembler = VaultPackageAssembler.create(vaultPackage);
                this.assemblers.add(this.mainPackageAssembler);
                ArtifactId mvnPackageId = ContentPackage2FeatureModelConverter.toArtifactId(vaultPackage);
                this.featuresManager.init(mvnPackageId.getGroupId(), mvnPackageId.getArtifactId(), mvnPackageId.getVersion());
                this.logger.info("Converting content-package '{}'...", (Object)vaultPackage.getId());
                this.traverse(vaultPackage);
                this.mainPackageAssembler.updateDependencies(this.mutableContentsIds);
                File contentPackageArchive = this.mainPackageAssembler.createPackage();
                this.processContentPackageArchive(contentPackageArchive, null, mvnPackageId, vaultPackage.getId());
                this.aclManager.addRepoinitExtension(this.assemblers, this.featuresManager);
                this.logger.info("Conversion complete!");
                this.featuresManager.serialize();
                this.emitter.endPackage();
            }
            finally {
                this.aclManager.reset();
                this.assemblers.clear();
                try {
                    vaultPackage.close();
                }
                catch (Exception exception) {}
            }
        }
        this.mutableContentsIds.clear();
        this.emitter.end();
    }

    private void orderDependencies(Map<PackageId, VaultPackage> idFileMap, Map<PackageId, VaultPackage> idPackageMapping, VaultPackage pack, Set<PackageId> visited) throws CyclicDependencyException {
        if (!visited.add(pack.getId())) {
            throw new CyclicDependencyException("Cyclic dependency detected, " + pack.getId() + " was previously visited already");
        }
        block0: for (Dependency dep : pack.getDependencies()) {
            for (Map.Entry<PackageId, VaultPackage> entry : idPackageMapping.entrySet()) {
                if (!dep.matches(entry.getKey())) continue;
                this.orderDependencies(idFileMap, idPackageMapping, entry.getValue(), visited);
                continue block0;
            }
        }
        idFileMap.put(pack.getId(), pack);
        idPackageMapping.remove(pack.getId());
    }

    public void processSubPackage(String path, String runMode, VaultPackage vaultPackage, boolean isEmbeddedPackage) throws Exception {
        Objects.requireNonNull(path, "Impossible to process a null vault package");
        Objects.requireNonNull(vaultPackage, "Impossible to process a null vault package");
        if (!this.isSubContentPackageIncluded(path)) {
            this.logger.info("Sub content-package {} is filtered out, so it won't be processed.", (Object)path);
            return;
        }
        this.emitter.startSubPackage(path, vaultPackage);
        PackageId originalPackageId = vaultPackage.getId();
        ArtifactId mvnPackageId = ContentPackage2FeatureModelConverter.toArtifactId(vaultPackage);
        VaultPackageAssembler clonedPackage = VaultPackageAssembler.create(vaultPackage);
        VaultPackageAssembler handler = this.mainPackageAssembler;
        this.assemblers.add(handler);
        Properties parentProps = handler.getPackageProperties();
        boolean isContainerPackage = PackageType.CONTAINER.equals(parentProps.get("packageType"));
        this.mainPackageAssembler = clonedPackage;
        this.traverse(vaultPackage);
        clonedPackage.updateDependencies(this.mutableContentsIds);
        if (isEmbeddedPackage && !isContainerPackage) {
            PackageId parentId = new PackageId((String)parentProps.get("group"), (String)parentProps.get("name"), (String)parentProps.get("version"));
            clonedPackage.addDependency(new Dependency(parentId));
        }
        File contentPackageArchive = clonedPackage.createPackage();
        this.processContentPackageArchive(contentPackageArchive, runMode, mvnPackageId, originalPackageId);
        this.mainPackageAssembler = handler;
        this.emitter.endSubPackage();
    }

    private void processContentPackageArchive(File contentPackageArchive, String runMode, ArtifactId mvnPackageId, PackageId originalPackageId) throws Exception {
        try (VaultPackage vaultPackage = this.open(contentPackageArchive);){
            PackageType packageType = VaultPackageUtils.detectPackageType(vaultPackage);
            if (PackageType.MIXED == packageType && this.failOnMixedPackages) {
                throw new Exception("Generated content-package '" + originalPackageId + "' located in file " + contentPackageArchive + " is of MIXED type");
            }
            if (PackageType.CONTENT != packageType || !this.dropContent) {
                this.artifactsDeployer.deploy(new FileArtifactWriter(contentPackageArchive), mvnPackageId);
                this.featuresManager.addArtifact(runMode, mvnPackageId);
            } else {
                this.mutableContentsIds.put(originalPackageId, VaultPackageUtils.getDependencies(vaultPackage));
                this.logger.info("Dropping package of PackageType.CONTENT {} (content-package id: {})", (Object)mvnPackageId.getArtifactId(), (Object)originalPackageId);
            }
        }
    }

    protected boolean isSubContentPackageIncluded(String path) {
        return this.subContentPackages.containsValue(path);
    }

    @Override
    protected void onFile(String entryPath, Archive archive, Archive.Entry entry) throws Exception {
        if (this.resourceFilter != null && this.resourceFilter.isFilteredOut(entryPath)) {
            throw new IllegalArgumentException("Path '" + entryPath + "' in archive " + archive.getMetaInf().getProperties() + " not allowed by user configuration, please check configured filtering patterns");
        }
        EntryHandler entryHandler = this.handlersManager.getEntryHandlerByEntryPath(entryPath);
        if (entryHandler == null) {
            entryHandler = this.mainPackageAssembler;
        }
        entryHandler.handle(entryPath, archive, entry, this);
    }

    private static ArtifactId toArtifactId(VaultPackage vaultPackage) {
        PackageId packageId = vaultPackage.getId();
        String groupId = Objects.requireNonNull(packageId.getGroup(), "group property not found in content-package " + vaultPackage + ", please check META-INF/vault/properties.xml").replace('/', '.');
        groupId = groupId.replaceAll(" ", "_");
        String artifactid = Objects.requireNonNull(packageId.getName(), "name property not found in content-package " + vaultPackage + ", please check META-INF/vault/properties.xml");
        artifactid = artifactid.replaceAll(" ", "_");
        String version = packageId.getVersionString();
        if (version == null || version.isEmpty()) {
            version = DEFEAULT_VERSION;
        }
        return new ArtifactId(groupId, artifactid, version, PACKAGE_CLASSIFIER, ZIP_TYPE);
    }

    @Override
    protected void addCdnPattern(Pattern cndPattern) {
        this.handlersManager.addEntryHandler(new NodeTypesEntryHandler(cndPattern));
    }
}

