/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.acl.Acl;
import org.apache.sling.feature.cpconverter.acl.AclManager;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.apache.sling.feature.cpconverter.shared.AbstractJcrNodeParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class RepPolicyEntryHandler
extends AbstractRegexEntryHandler {
    private final SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();

    public RepPolicyEntryHandler() {
        super("/jcr_root(.*/)_rep_policy.xml");
    }

    @Override
    public void handle(String path, Archive archive, Archive.Entry entry, ContentPackage2FeatureModelConverter converter) throws Exception {
        boolean hasRejectedAcls;
        Matcher matcher = this.getPattern().matcher(path);
        if (!matcher.matches()) {
            throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
        }
        String resourcePath = matcher.group(1);
        TransformerHandler handler = this.saxTransformerFactory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        handler.getTransformer().setOutputProperty("encoding", "UTF-8");
        StringWriter stringWriter = new StringWriter();
        handler.setResult(new StreamResult(stringWriter));
        RepPolicyParser systemUserParser = new RepPolicyParser(Paths.get(resourcePath, new String[0]), Paths.get(PlatformNameFormat.getRepositoryPath((String)resourcePath), new String[0]), converter.getAclManager(), handler);
        try (InputStream input = archive.openInputStream(entry);){
            hasRejectedAcls = (Boolean)systemUserParser.parse(input);
        }
        if (hasRejectedAcls) {
            try (StringReader reader = new StringReader(stringWriter.toString());
                 OutputStreamWriter writer = new OutputStreamWriter(converter.getMainPackageAssembler().createEntry(path));){
                IOUtils.copy((Reader)reader, (Writer)writer);
            }
        }
    }

    private static final class RepPolicyParser
    extends AbstractJcrNodeParser<Boolean> {
        private static final String REP_ACL = "rep:ACL";
        private static final String REP_GRANT_ACE = "rep:GrantACE";
        private static final String REP_DENY_ACE = "rep:DenyACE";
        private static final String REP_RESTRICTIONS = "rep:Restrictions";
        private static final String REP_PRINCIPAL_NAME = "rep:principalName";
        private static final String REP_PRIVILEGES = "rep:privileges";
        private static final Map<String, String> operations = new HashMap<String, String>();
        private static final String[] RESTRICTIONS;
        private static final Pattern typeIndicatorPattern;
        private final Stack<Acl> acls = new Stack();
        private final Path path;
        private final Path repositoryPath;
        private final AclManager aclManager;
        private final TransformerHandler handler;
        private boolean onRepAclNode = false;
        private boolean hasRejectedNodes = false;
        private boolean processCurrentAcl = false;

        public RepPolicyParser(Path path, Path repositoryPath, AclManager aclManager, TransformerHandler handler) {
            super(REP_ACL);
            this.path = path;
            this.repositoryPath = repositoryPath;
            this.aclManager = aclManager;
            this.handler = handler;
        }

        @Override
        public void startDocument() throws SAXException {
            this.handler.startDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.onRepAclNode) {
                String primaryType = attributes.getValue("jcr:primaryType");
                if (REP_GRANT_ACE.equals(primaryType) || REP_DENY_ACE.equals(primaryType)) {
                    String principalName = attributes.getValue(REP_PRINCIPAL_NAME);
                    String operation = operations.get(primaryType);
                    String privileges = RepPolicyParser.extractValue(attributes.getValue(REP_PRIVILEGES));
                    Acl acl = new Acl(operation, privileges, this.path, this.repositoryPath);
                    this.processCurrentAcl = this.aclManager.addAcl(principalName, acl);
                    if (this.processCurrentAcl) {
                        this.acls.add(acl);
                    } else {
                        this.hasRejectedNodes = true;
                    }
                } else if (REP_RESTRICTIONS.equals(primaryType) && !this.acls.isEmpty() && this.processCurrentAcl) {
                    this.acls.add(this.acls.peek());
                    for (String restriction : RESTRICTIONS) {
                        String path = RepPolicyParser.extractValue(attributes.getValue(restriction));
                        if (path == null || path.isEmpty()) continue;
                        this.acls.peek().addRestriction(restriction + ',' + path);
                    }
                }
            } else {
                super.startElement(uri, localName, qName, attributes);
            }
            if (!this.onRepAclNode || !this.processCurrentAcl) {
                this.handler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.onRepAclNode && this.processCurrentAcl && !this.acls.isEmpty()) {
                this.acls.pop();
            } else {
                this.processCurrentAcl = false;
                this.handler.endElement(uri, localName, qName);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.handler.endDocument();
        }

        @Override
        protected void onJcrRootElement(String uri, String localName, String qName, Attributes attributes) {
            this.onRepAclNode = true;
        }

        @Override
        protected Boolean getParsingResult() {
            return this.hasRejectedNodes;
        }

        private static String extractValue(String expression) {
            if (expression == null || expression.isEmpty()) {
                return expression;
            }
            Matcher matcher = typeIndicatorPattern.matcher(expression);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return expression;
        }

        static {
            operations.put(REP_GRANT_ACE, "allow");
            operations.put(REP_DENY_ACE, "deny");
            RESTRICTIONS = new String[]{"rep:glob", "rep:ntNames", "rep:prefixes", "rep:itemNames"};
            typeIndicatorPattern = Pattern.compile("\\{[^\\}]+\\}\\[(.+)\\]");
        }
    }
}

