/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractContentPackageHandler
extends AbstractRegexEntryHandler {
    private static final String SNAPSHOT_POSTFIX = "-SNAPSHOT";
    private final File temporaryDir = new File(System.getProperty("java.io.tmpdir"), "sub-content-packages");

    public AbstractContentPackageHandler() {
        super("/jcr_root/(?:etc/packages|apps/.+/install(?:\\.([^/]+))?)/.+.zip");
        this.temporaryDir.mkdirs();
    }

    @Override
    public final void handle(String path, Archive archive, Archive.Entry entry, ContentPackage2FeatureModelConverter converter) throws Exception {
        this.logger.info("Processing sub-content package '{}'...", (Object)entry.getName());
        File temporaryContentPackage = new File(this.temporaryDir, entry.getName());
        if (entry.getName().contains(SNAPSHOT_POSTFIX) && temporaryContentPackage.exists()) {
            this.logger.debug("SNAPSHOT content-package detected, deleting previous version on {}...", (Object)temporaryContentPackage);
            if (temporaryContentPackage.delete()) {
                this.logger.debug("Previous SNAPSHOT content-package version on {} deleted", (Object)temporaryContentPackage);
            } else {
                this.logger.warn("Impossible to delete previous SNAPSHOT content-package version on {}, please check current user permissions", (Object)temporaryContentPackage);
            }
        }
        if (!temporaryContentPackage.exists()) {
            this.logger.debug("Extracting sub-content package '{}' to {} for future analysis...", (Object)entry.getName(), (Object)temporaryContentPackage);
            try (InputStream input = archive.openInputStream(entry);
                 FileOutputStream output = new FileOutputStream(temporaryContentPackage);){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            this.logger.debug("Sub-content package '{}' successfully extracted to {} ", (Object)entry.getName(), (Object)temporaryContentPackage);
        }
        Matcher matcher = this.getPattern().matcher(path);
        String runMode = null;
        if (!matcher.matches()) {
            throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
        }
        if (StringUtils.isNotBlank((String)matcher.group(1))) {
            runMode = matcher.group(1);
            this.logger.debug("Runmode {} was extracted from path {}", (Object)runMode, (Object)path);
        }
        try (VaultPackage vaultPackage = converter.open(temporaryContentPackage);){
            this.processSubPackage(path, runMode, vaultPackage, converter);
        }
        this.logger.info("Sub-content package '{}' processing is over", (Object)entry.getName());
    }

    protected abstract void processSubPackage(String var1, String var2, VaultPackage var3, ContentPackage2FeatureModelConverter var4) throws Exception;
}

