/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.config.VaultSettings;
import org.apache.jackrabbit.vault.fs.io.AbstractArchive;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipArchive
extends AbstractArchive {
    private static final Logger log = LoggerFactory.getLogger(ZipArchive.class);
    private final File file;
    private final boolean isTempFile;
    private DefaultMetaInf inf;
    private JarFile jar;
    private EntryImpl root;

    public ZipArchive(@Nonnull File zipFile) {
        this(zipFile, false);
    }

    public ZipArchive(@Nonnull File zipFile, boolean isTempFile) {
        this.file = zipFile;
        this.isTempFile = isTempFile;
    }

    @Override
    public void open(boolean strict) throws IOException {
        if (this.jar != null) {
            return;
        }
        this.jar = new JarFile(this.file);
        this.root = new EntryImpl("", true);
        this.inf = new DefaultMetaInf();
        Enumeration<JarEntry> e = this.jar.entries();
        while (e.hasMoreElements()) {
            String[] names;
            ZipEntry entry = e.nextElement();
            String path = entry.getName();
            if (path.startsWith("META-INF/vault/")) {
                try {
                    this.inf.load(this.jar.getInputStream(entry), this.file.getPath() + ":" + path);
                }
                catch (ConfigurationException e1) {
                    throw new IOException(e1);
                }
            }
            if ((names = Text.explode(path, 47)).length <= 0) continue;
            EntryImpl je = this.root;
            for (int i = 0; i < names.length; ++i) {
                je = i == names.length - 1 ? je.add(names[i], entry.isDirectory()) : je.add(names[i], true);
            }
            je.zipEntryName = entry.getName();
            log.debug("scanning jar: {}", (Object)je.zipEntryName);
        }
        if (this.inf.getFilter() == null) {
            log.debug("Zip {} does not contain filter definition.", (Object)this.file.getPath());
        }
        if (this.inf.getConfig() == null) {
            log.debug("Zip {} does not contain vault config.", (Object)this.file.getPath());
        }
        if (this.inf.getSettings() == null) {
            log.debug("Zip {} does not contain vault settings. using default.", (Object)this.file.getPath());
            VaultSettings settings = new VaultSettings();
            settings.getIgnoredNames().add(".svn");
            this.inf.setSettings(settings);
        }
        if (this.inf.getProperties() == null) {
            log.debug("Zip {} does not contain properties.", (Object)this.file.getPath());
        }
        if (this.inf.getNodeTypes().isEmpty()) {
            log.debug("Zip {} does not contain nodetypes.", (Object)this.file.getPath());
        }
    }

    @Override
    @Nullable
    public InputStream openInputStream(@Nullable Archive.Entry entry) throws IOException {
        EntryImpl e = (EntryImpl)entry;
        if (e == null || e.zipEntryName == null) {
            return null;
        }
        ZipEntry ze = this.jar.getEntry(e.zipEntryName);
        if (ze == null) {
            throw new IOException("ZipEntry could not be found: " + e.zipEntryName);
        }
        return this.jar.getInputStream(ze);
    }

    @Override
    @Nullable
    public VaultInputSource getInputSource(@Nullable Archive.Entry entry) throws IOException {
        EntryImpl e = (EntryImpl)entry;
        if (e == null || e.zipEntryName == null) {
            return null;
        }
        final ZipEntry ze = this.jar.getEntry(e.zipEntryName);
        if (ze == null) {
            throw new IOException("ZipEntry could not be found: " + e.zipEntryName);
        }
        return new VaultInputSource(){
            {
                this.setSystemId(ze.getName());
            }

            @Override
            public InputStream getByteStream() {
                try {
                    return ZipArchive.this.jar.getInputStream(ze);
                }
                catch (IOException e1) {
                    return null;
                }
            }

            @Override
            public long getContentLength() {
                return ze.getSize();
            }

            @Override
            public long getLastModified() {
                try {
                    return ze.getTime();
                }
                catch (Exception e1) {
                    return 0L;
                }
            }
        };
    }

    @Override
    public void close() {
        try {
            if (this.jar != null) {
                this.jar.close();
                this.jar = null;
            }
            if (this.file != null && this.isTempFile) {
                FileUtils.deleteQuietly((File)this.file);
            }
        }
        catch (IOException e) {
            log.warn("Error during close.", (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public Archive.Entry getRoot() throws IOException {
        return this.root;
    }

    @Override
    @Nonnull
    public MetaInf getMetaInf() {
        if (this.inf == null) {
            throw new IllegalStateException("Archive not open.");
        }
        return this.inf;
    }

    @Nullable
    public File getFile() {
        return this.file.exists() ? this.file : null;
    }

    public long getFileSize() {
        return this.file.length();
    }

    public String toString() {
        return this.file.getPath();
    }

    private static class EntryImpl
    implements Archive.Entry {
        private final String name;
        private String zipEntryName;
        private final boolean isDirectory;
        private Map<String, EntryImpl> children;

        private EntryImpl(@Nonnull String name, boolean directory) {
            this.name = name;
            this.isDirectory = directory;
        }

        @Nonnull
        private EntryImpl add(@Nonnull EntryImpl e) {
            if (this.children == null) {
                this.children = new LinkedHashMap<String, EntryImpl>();
            }
            this.children.put(e.getName(), e);
            return e;
        }

        @Nonnull
        public EntryImpl add(@Nonnull String name, boolean isDirectory) {
            EntryImpl ret;
            if (this.children != null && (ret = this.children.get(name)) != null) {
                return ret;
            }
            return this.add(new EntryImpl(name, isDirectory));
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        @Override
        @Nonnull
        public Collection<? extends Archive.Entry> getChildren() {
            return this.children == null ? Collections.emptyList() : this.children.values();
        }

        @Override
        @Nullable
        public Archive.Entry getChild(@Nonnull String name) {
            return this.children == null ? null : this.children.get(name);
        }
    }
}

