/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.analyser.AbstractApiRegionsAnalyserTask;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class CheckApiRegionsCrossFeatureDups
extends AbstractApiRegionsAnalyserTask {
    public String getId() {
        return "api-regions-crossfeature-dups";
    }

    public String getName() {
        return "Api Regions cross-feature duplicate export task";
    }

    @Override
    protected void execute(ApiRegions apiRegions, AnalyserTaskContext ctx) throws Exception {
        Set<String> checkedRegions = this.splitListConfig((String)ctx.getConfiguration().get("regions"));
        Set<String> ignoredPackages = this.splitListConfig((String)ctx.getConfiguration().get("ignoredPackages"));
        Set<String> warningPackages = this.splitListConfig((String)ctx.getConfiguration().get("warningPackages"));
        HashMap regionExports = new HashMap();
        ArrayList<ArtifactId> apiRegionsFeatures = new ArrayList<ArtifactId>();
        for (ApiRegion r : apiRegions.listRegions()) {
            apiRegionsFeatures.addAll(Arrays.asList(r.getFeatureOrigins()));
            if (!checkedRegions.isEmpty() && !checkedRegions.contains(r.getName())) continue;
            HashSet exports = (HashSet)regionExports.get(r.getName());
            if (exports == null) {
                exports = new HashSet();
                regionExports.put(r.getName(), exports);
            }
            exports.addAll(r.listExports().stream().map(ApiExport::getName).collect(Collectors.toSet()));
        }
        FeatureDescriptor f = ctx.getFeatureDescriptor();
        for (BundleDescriptor bd : f.getBundleDescriptors()) {
            ArrayList<ArtifactId> borgs = new ArrayList<ArtifactId>(Arrays.asList(bd.getArtifact().getFeatureOrigins()));
            borgs.removeAll(apiRegionsFeatures);
            if (borgs.isEmpty()) continue;
            HashSet<String> reportedPackages = new HashSet<String>();
            for (PackageInfo pi : bd.getExportedPackages()) {
                String pkgName = pi.getName();
                for (Map.Entry entry : regionExports.entrySet()) {
                    if (!((Set)entry.getValue()).contains(pkgName) || reportedPackages.contains(pkgName) || this.matchesSet(pkgName, ignoredPackages)) continue;
                    reportedPackages.add(pi.getName());
                    String msg = "Package overlap found between region " + (String)entry.getKey() + " and bundle " + bd.getBundleSymbolicName() + " " + bd.getBundleVersion() + " which comes from a feature without API Regions: " + borgs + ". Both export package: " + pi.getName();
                    if (this.matchesSet(pkgName, warningPackages)) {
                        ctx.reportWarning(msg);
                        continue;
                    }
                    ctx.reportError(msg);
                }
            }
        }
    }

    private boolean matchesSet(String pkg, Set<String> set) {
        for (String e : set) {
            if (!(e.endsWith("*") ? pkg.startsWith(e.substring(0, e.length() - 1)) : pkg.equals(e))) continue;
            return true;
        }
        return false;
    }

    private Set<String> splitListConfig(String value) {
        if (value == null) {
            return Collections.emptySet();
        }
        return Arrays.asList(value.split(",")).stream().map(String::trim).collect(Collectors.toSet());
    }
}

