/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonMergePatch;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonPointer;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.BufferStrategyFactory;
import org.apache.johnzon.core.JsonBuilderFactoryImpl;
import org.apache.johnzon.core.JsonDoubleImpl;
import org.apache.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonMergePatchDiff;
import org.apache.johnzon.core.JsonMergePatchImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonParserFactoryImpl;
import org.apache.johnzon.core.JsonPatchBuilderImpl;
import org.apache.johnzon.core.JsonPatchDiff;
import org.apache.johnzon.core.JsonPointerImpl;
import org.apache.johnzon.core.JsonReaderFactoryImpl;
import org.apache.johnzon.core.JsonStringImpl;
import org.apache.johnzon.core.JsonWriterFactoryImpl;

public class JsonProviderImpl
extends JsonProvider
implements Serializable {
    private final Supplier<BufferStrategy.BufferProvider<char[]>> bufferProvider = new Cached<BufferStrategy.BufferProvider<char[]>>(() -> BufferStrategyFactory.valueOf(System.getProperty("org.apache.johnzon.buffer-strategy", "QUEUE")).newCharProvider(Integer.getInteger("org.apache.johnzon.default-char-provider.length", 1024)));
    private final JsonReaderFactory readerFactory = new JsonReaderFactoryImpl(null);
    private final JsonParserFactory parserFactory = new JsonParserFactoryImpl(null);
    private final JsonGeneratorFactory generatorFactory = new JsonGeneratorFactoryImpl(null);
    private final JsonWriterFactory writerFactory = new JsonWriterFactoryImpl(null);
    private final Supplier<JsonBuilderFactory> builderFactory = new Cached<JsonBuilderFactory>(() -> new JsonBuilderFactoryImpl(null, this.bufferProvider.get()));

    public JsonParser createParser(InputStream in) {
        return this.parserFactory.createParser(in);
    }

    public JsonParser createParser(Reader reader) {
        return this.parserFactory.createParser(reader);
    }

    public JsonReader createReader(InputStream in) {
        return this.readerFactory.createReader(in);
    }

    public JsonReader createReader(Reader reader) {
        return this.readerFactory.createReader(reader);
    }

    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        return config == null || config.isEmpty() ? this.parserFactory : new JsonParserFactoryImpl(config);
    }

    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        return config == null || config.isEmpty() ? this.readerFactory : new JsonReaderFactoryImpl(config);
    }

    public JsonGenerator createGenerator(Writer writer) {
        return this.generatorFactory.createGenerator(writer);
    }

    public JsonGenerator createGenerator(OutputStream out) {
        return this.generatorFactory.createGenerator(out);
    }

    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        return config == null || config.isEmpty() ? this.generatorFactory : new JsonGeneratorFactoryImpl(config);
    }

    public JsonWriter createWriter(Writer writer) {
        return this.writerFactory.createWriter(writer);
    }

    public JsonWriter createWriter(OutputStream out) {
        return this.writerFactory.createWriter(out);
    }

    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        return config == null || config.isEmpty() ? this.writerFactory : new JsonWriterFactoryImpl(config);
    }

    public JsonObjectBuilder createObjectBuilder() {
        return this.builderFactory.get().createObjectBuilder();
    }

    public JsonObjectBuilder createObjectBuilder(JsonObject jsonObject) {
        return this.builderFactory.get().createObjectBuilder(jsonObject);
    }

    public JsonObjectBuilder createObjectBuilder(Map<String, Object> initialValues) {
        return this.builderFactory.get().createObjectBuilder(initialValues);
    }

    public JsonArrayBuilder createArrayBuilder() {
        return this.builderFactory.get().createArrayBuilder();
    }

    public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
        return this.builderFactory.get().createArrayBuilder(initialData);
    }

    public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
        return this.builderFactory.get().createArrayBuilder(initialData);
    }

    public JsonString createValue(String value) {
        return new JsonStringImpl(value);
    }

    public JsonNumber createValue(int value) {
        return new JsonLongImpl(value);
    }

    public JsonNumber createValue(long value) {
        return new JsonLongImpl(value);
    }

    public JsonNumber createValue(double value) {
        return new JsonDoubleImpl(value);
    }

    public JsonNumber createValue(BigDecimal value) {
        return new JsonNumberImpl(value);
    }

    public JsonNumber createValue(BigInteger value) {
        return new JsonNumberImpl(new BigDecimal(value.toString()));
    }

    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        JsonBuilderFactory builderFactory = this.builderFactory.get();
        return config == null || config.isEmpty() ? builderFactory : new JsonBuilderFactoryImpl(config, this.bufferProvider.get());
    }

    public JsonPatchBuilder createPatchBuilder() {
        return new JsonPatchBuilderImpl(this);
    }

    public JsonPatchBuilder createPatchBuilder(JsonArray initialData) {
        return new JsonPatchBuilderImpl(this, initialData);
    }

    public JsonPointer createPointer(String path) {
        return new JsonPointerImpl(this, path);
    }

    public JsonPatch createPatch(JsonArray array) {
        return this.createPatchBuilder(array).build();
    }

    public JsonPatch createDiff(JsonStructure source, JsonStructure target) {
        return new JsonPatchDiff(this, source, target).calculateDiff();
    }

    public JsonMergePatch createMergePatch(JsonValue patch) {
        return new JsonMergePatchImpl(patch, this.bufferProvider.get());
    }

    public JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
        return new JsonMergePatchDiff(source, target, this.bufferProvider.get()).calculateDiff();
    }

    private static class Cached<T>
    implements Supplier<T> {
        private final Supplier<T> delegate;
        private volatile T computed;

        private Cached(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.computed == null) {
                Cached cached = this;
                synchronized (cached) {
                    if (this.computed == null) {
                        this.computed = this.delegate.get();
                    }
                }
            }
            return this.computed;
        }
    }
}

