/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;

public class NodeTypesEntryHandler
extends AbstractRegexEntryHandler {
    public NodeTypesEntryHandler() {
        super("/META-INF/vault/nodetypes\\.cnd");
    }

    public NodeTypesEntryHandler(Pattern pattern) {
        super(pattern);
    }

    @Override
    public void handle(String path, Archive archive, Archive.Entry entry, ContentPackage2FeatureModelConverter converter) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(archive.openInputStream(entry)));){
            String nodetypeRegistrationSentence;
            converter.getAclManager().addNodetypeRegistrationSentence("register nodetypes");
            converter.getAclManager().addNodetypeRegistrationSentence("<<===");
            while ((nodetypeRegistrationSentence = reader.readLine()) != null) {
                if (nodetypeRegistrationSentence.isEmpty()) {
                    converter.getAclManager().addNodetypeRegistrationSentence("");
                    continue;
                }
                converter.getAclManager().addNodetypeRegistrationSentence("<< " + nodetypeRegistrationSentence);
            }
            converter.getAclManager().addNodetypeRegistrationSentence("===>>");
        }
    }
}

