/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Packaging.class}, immediate=true, property={"service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class PackagingImpl
implements Packaging {
    private static final Logger log = LoggerFactory.getLogger(PackagingImpl.class);
    @Reference
    private PackageEventDispatcher eventDispatcher;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile PackageRegistry baseRegistry;
    private final PackageManagerImpl pkgManager = new PackageManagerImpl();
    private String[] packageRoots = new String[0];

    public PackagingImpl() {
        this.pkgManager.setDispatcher(this.eventDispatcher);
    }

    @Activate
    private void activate(Config config) {
        this.packageRoots = config.packageRoots();
        log.info("Jackrabbit Filevault Packaging initialized with roots {}", (Object)Arrays.toString(this.packageRoots));
    }

    @Override
    public PackageManager getPackageManager() {
        return this.pkgManager;
    }

    @Override
    public JcrPackageManager getPackageManager(Session session) {
        JcrPackageManagerImpl mgr = new JcrPackageManagerImpl(session, this.packageRoots);
        mgr.setDispatcher(this.eventDispatcher);
        mgr.getInternalRegistry().setBaseRegistry(this.baseRegistry);
        return mgr;
    }

    @Override
    public JcrPackageDefinition createPackageDefinition(Node defNode) {
        return new JcrPackageDefinitionImpl(defNode);
    }

    @Override
    public JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        JcrPackageManager pMgr = this.getPackageManager(node.getSession());
        return pMgr.open(node, allowInvalid);
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Packaging Service")
    static @interface Config {
        @AttributeDefinition
        public String[] packageRoots() default {"/etc/packages"};
    }
}

