/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.extensions.AnalyserMetaDataExtension;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.ContainerDescriptor;
import org.apache.sling.feature.scanner.Descriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.impl.BundleDescriptorImpl;
import org.apache.sling.feature.scanner.impl.FeatureDescriptorImpl;
import org.apache.sling.feature.scanner.spi.ExtensionScanner;
import org.apache.sling.feature.scanner.spi.FrameworkScanner;

public class Scanner {
    private final ArtifactProvider artifactProvider;
    private final List<ExtensionScanner> extensionScanners;
    private final List<FrameworkScanner> frameworkScanners;
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    public Scanner(ArtifactProvider artifactProvider, List<ExtensionScanner> extensionScanners, List<FrameworkScanner> frameworkScanners) throws IOException {
        this.artifactProvider = artifactProvider;
        this.extensionScanners = extensionScanners == null ? Scanner.getServices(ExtensionScanner.class) : extensionScanners;
        this.frameworkScanners = frameworkScanners == null ? Scanner.getServices(FrameworkScanner.class) : frameworkScanners;
    }

    public Scanner(ArtifactProvider artifactProvider) throws IOException {
        this(artifactProvider, null, null);
    }

    private static <T> List<T> getServices(Class<T> clazz) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz);
        ArrayList<T> list = new ArrayList<T>();
        for (T task : loader) {
            list.add(task);
        }
        return list;
    }

    public BundleDescriptor scanBundle(Artifact bundle) throws IOException {
        return this.doScan(bundle, bundle.getStartOrder());
    }

    @Deprecated
    public BundleDescriptor scan(Artifact bundle, int startLevel) throws IOException {
        return this.doScan(bundle, startLevel);
    }

    private BundleDescriptor doScan(Artifact bundle, int startLevel) throws IOException {
        String key = bundle.getId().toMvnId().concat(":").concat(String.valueOf(startLevel)).concat(":").concat(Stream.of(bundle.getFeatureOrigins()).map(ArtifactId::toMvnId).collect(Collectors.joining(",")));
        BundleDescriptor desc = (BundleDescriptor)this.cache.get(key);
        if (desc == null) {
            URL file = this.artifactProvider.provide(bundle.getId());
            if (file == null) {
                throw new IOException("Unable to find file for " + bundle.getId());
            }
            desc = new BundleDescriptorImpl(bundle, file, startLevel);
            this.cache.put(key, desc);
        }
        return desc;
    }

    private void getBundleInfos(Bundles bundles, ContainerDescriptor desc) throws IOException {
        for (Artifact bundle : bundles) {
            BundleDescriptor bundleDesc = this.scanBundle(bundle);
            desc.getBundleDescriptors().add(bundleDesc);
        }
    }

    private void scanExtensions(Feature f, ContainerDescriptor desc) throws IOException {
        for (Extension ext : f.getExtensions()) {
            ExtensionScanner scanner;
            if (AnalyserMetaDataExtension.isAnalyserMetaDataExtension(ext)) continue;
            Descriptor extDesc = null;
            Iterator<ExtensionScanner> iterator = this.extensionScanners.iterator();
            while (iterator.hasNext() && (extDesc = (scanner = iterator.next()).scan(f, ext, this.artifactProvider)) == null) {
            }
            if (extDesc == null) continue;
            desc.getRequirements().addAll(extDesc.getRequirements());
            desc.getCapabilities().addAll(extDesc.getCapabilities());
            desc.getExportedPackages().addAll(extDesc.getExportedPackages());
            desc.getImportedPackages().addAll(extDesc.getImportedPackages());
            desc.getDynamicImportedPackages().addAll(extDesc.getDynamicImportedPackages());
            desc.getArtifactDescriptors().addAll(((ContainerDescriptor)extDesc).getArtifactDescriptors());
            desc.getBundleDescriptors().addAll(((ContainerDescriptor)extDesc).getBundleDescriptors());
        }
    }

    private void compact(ContainerDescriptor desc) {
    }

    public FeatureDescriptor scan(Feature feature) throws IOException {
        String key = feature.getId().toMvnId();
        FeatureDescriptorImpl desc = (FeatureDescriptorImpl)this.cache.get(key);
        if (desc == null) {
            desc = new FeatureDescriptorImpl(feature);
            this.populateCache(feature);
            this.getBundleInfos(feature.getBundles(), desc);
            this.scanExtensions(feature, desc);
            this.compact(desc);
            desc.lock();
            this.cache.put(key, desc);
        }
        return desc;
    }

    private void populateCache(Feature feature) throws IOException {
        AnalyserMetaDataExtension extension = AnalyserMetaDataExtension.getAnalyserMetaDataExtension(feature);
        if (extension != null) {
            for (Artifact bundle : feature.getBundles()) {
                Map<String, String> headers;
                ArtifactId id = bundle.getId();
                String key = id.toMvnId().concat(":").concat(String.valueOf(bundle.getStartOrder())).concat(":").concat(Stream.of(bundle.getFeatureOrigins()).map(ArtifactId::toMvnId).collect(Collectors.joining(",")));
                if (this.cache.get(key) != null || (headers = extension.getManifest(id)) == null) continue;
                Manifest manifest = new Manifest();
                headers.forEach(manifest.getMainAttributes()::putValue);
                BundleDescriptorImpl desc = new BundleDescriptorImpl(bundle, this.artifactProvider, manifest, bundle.getStartOrder());
                this.cache.put(key, desc);
            }
        }
    }

    public BundleDescriptor scan(ArtifactId framework, Map<String, String> props) throws IOException {
        String key;
        BundleDescriptor desc;
        StringBuilder sb = new StringBuilder();
        sb.append(framework.toMvnId());
        if (props != null) {
            TreeMap<String, String> sortedMap = new TreeMap<String, String>(props);
            for (Map.Entry entry : sortedMap.entrySet()) {
                sb.append(":").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
        }
        if ((desc = (BundleDescriptor)this.cache.get(key = sb.toString())) == null) {
            FrameworkScanner scanner;
            Iterator<FrameworkScanner> iterator = this.frameworkScanners.iterator();
            while (iterator.hasNext() && (desc = (scanner = iterator.next()).scan(framework, props, this.artifactProvider)) == null) {
            }
            if (desc == null) {
                throw new IOException("No scanner found for framework " + framework.toMvnId());
            }
            this.cache.put(key, desc);
        }
        return desc;
    }
}

