/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.ContentPackageDescriptor;

public class ContentPackageDescriptorImpl
extends ContentPackageDescriptor {
    public static final String METADATA_PACKAGE = "content-package";
    public static final String METADATA_PATH = "content-path";
    private final List<BundleDescriptor> bundles;
    private final List<Configuration> configs;
    private final List<String> paths;
    private ContentPackageDescriptor parentContentPackage;
    private String parentContentPath;
    private final Manifest manifest;
    private final URL artifactFile;
    private final Artifact artifact;
    private final Properties packageProperties;

    public ContentPackageDescriptorImpl(String name, Artifact artifact, URL url, Manifest manifest, List<BundleDescriptor> bundles, List<String> paths, List<Configuration> configs, Properties packageProps) {
        super(name);
        this.bundles = bundles == null ? new ArrayList() : bundles;
        this.paths = paths == null ? new ArrayList() : paths;
        this.configs = configs == null ? new ArrayList() : configs;
        this.artifact = artifact;
        this.artifact.getId();
        this.artifactFile = url;
        this.manifest = manifest;
        this.packageProperties = packageProps;
    }

    @Override
    public URL getArtifactFile() {
        return this.artifactFile;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public List<String> getContentPaths() {
        return this.isLocked() ? Collections.unmodifiableList(this.paths) : this.paths;
    }

    @Override
    public List<BundleDescriptor> getBundles() {
        return this.isLocked() ? Collections.unmodifiableList(this.bundles) : this.bundles;
    }

    @Override
    public List<Configuration> getConfigurations() {
        return this.isLocked() ? Collections.unmodifiableList(this.configs) : this.configs;
    }

    @Override
    public ContentPackageDescriptor getParentContentPackage() {
        return this.parentContentPackage;
    }

    @Override
    public String getParentContentPath() {
        return this.parentContentPath;
    }

    public void setParentContentPackageInfo(ContentPackageDescriptor desc, String path) {
        this.checkLocked();
        this.parentContentPackage = desc;
        this.parentContentPath = path;
    }

    @Override
    public Properties getPackageProperties() {
        return this.packageProperties;
    }
}

