/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner;

import java.util.jar.Manifest;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.apache.sling.feature.scanner.impl.BundleDescriptorImpl;

public abstract class BundleDescriptor
extends ArtifactDescriptor
implements Comparable<BundleDescriptor> {
    protected BundleDescriptor(String name) {
        super(name);
    }

    public abstract String getBundleSymbolicName();

    public abstract String getBundleVersion();

    @Override
    public abstract Manifest getManifest();

    @Deprecated
    public abstract int getBundleStartLevel();

    public boolean isExportingPackage(String packageName) {
        for (PackageInfo i : this.getExportedPackages()) {
            if (!i.getName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean isExportingPackage(PackageInfo info) {
        for (PackageInfo i : this.getExportedPackages()) {
            if (!i.getName().equals(info.getName()) || info.getVersion() != null && !info.getPackageVersionRange().includes(i.getPackageVersion())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BundleDescriptorImpl) {
            return this.getBundleSymbolicName().equals(((BundleDescriptorImpl)obj).getBundleSymbolicName()) && this.getBundleVersion().equals(((BundleDescriptorImpl)obj).getBundleVersion());
        }
        return false;
    }

    public int hashCode() {
        return (this.getBundleSymbolicName() + ':' + this.getBundleVersion()).hashCode();
    }

    @Override
    public String toString() {
        return "BundleInfo [symbolicName=" + this.getBundleSymbolicName() + ", version=" + this.getBundleVersion() + "]";
    }

    @Override
    public int compareTo(BundleDescriptor o) {
        return (this.getBundleSymbolicName() + ':' + this.getBundleVersion()).compareTo(o.getBundleSymbolicName() + ':' + o.getBundleVersion());
    }
}

