/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.ArrayList;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.impl.ContentPackageDescriptor;

public class CheckContentPackageForInstallables
implements AnalyserTask {
    @Override
    public String getName() {
        return "Content Packages Installable Check";
    }

    @Override
    public String getId() {
        return "content-packages-installables";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        ArrayList<ContentPackageDescriptor> contentPackages = new ArrayList<ContentPackageDescriptor>();
        for (ArtifactDescriptor d : ctx.getFeatureDescriptor().getArtifactDescriptors()) {
            if (!(d instanceof ContentPackageDescriptor)) continue;
            contentPackages.add((ContentPackageDescriptor)d);
        }
        if (contentPackages.isEmpty()) {
            return;
        }
        for (ContentPackageDescriptor cp : contentPackages) {
            if (!cp.hasEmbeddedArtifacts() || cp.isEmbeddedInContentPackage()) continue;
            ctx.reportError("Content package " + cp.getName() + " (" + cp.getArtifact().getId().toMvnId() + " ) contains " + String.valueOf(cp.bundles.size()) + " bundles and " + String.valueOf(cp.configs.size()) + " configurations.");
        }
    }
}

