/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;

public class CheckApisJarsProperties
implements AnalyserTask {
    private static final String SCM_LOCATION = "scm-location";
    private static final String API_IDS = "api-ids";
    private static final String SCM_IDS = "source-ids";
    private static final String SCM_CLASSIFIER = "source-classifier";
    private static final String JAVADOC_LINKS = "javadoc-links";
    private static final String JAVADOC_CLASSPATH = "javadoc-classpath";
    private static final String EXTENSION_NAME = "apis-jar-config";
    private static final String PROP_API_VERSION = "api-version";
    private static final String PROP_JAVADOC_SOURCE_LEVEL = "javadoc-source-level";
    private static final String PROP_LICENSE_REPORT = "license-report";
    private static final String PROP_MANIFEST_ENTRIES = "manifest-entries";
    private static final String PROP_CLASSIFIER_MAPPINGS = "classifier-mappings";
    private static final String PROP_REGION_MAPPINGS = "region-mappings";
    private static final String PROP_BUNDLE_RESOURCES = "bundle-resources";
    private static final String PROP_BUNDLE_RESOURCE_FOLDERS = "bundle-resource-folders";
    private static final String PROP_JAVADOC_CLASSPATH_TOPS = "javadoc-classpath-tops";
    private static final String PROP_JAVADOC_CLASSPATH_HIGHEST_VERSIONS = "javadoc-classpath-highest-versions";
    private static final String PROP_JAVADOC_CLASSPATH_REMOVALS = "javadoc-classpath-removals";
    private static final String PROP_JAVADOC_LINKS = "javadoc-links";
    private static final String PROP_LICENSE_DEFAULTS = "license-defaults";
    private static final String PROP_LICENSE_FOOTER = "license-footer";
    private static final String PROP_LICENSE_HEADER = "license-header";

    @Override
    public String getId() {
        return "apis-jar";
    }

    @Override
    public String getName() {
        return "APIs jar properties check";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        for (Artifact artifact : ctx.getFeature().getBundles()) {
            this.validateSourceInfo(ctx, artifact);
            this.checkIdValidity(ctx, artifact, SCM_IDS);
            this.checkIdValidity(ctx, artifact, API_IDS);
            this.checkIdValidity(ctx, artifact, JAVADOC_CLASSPATH);
            this.checkJavadocLinks(ctx, artifact);
        }
        this.checkExtension(ctx);
    }

    private void checkExtension(AnalyserTaskContext ctx) {
        Extension ext = ctx.getFeature().getExtensions().getByName(EXTENSION_NAME);
        if (ext != null) {
            if (ext.getType() != ExtensionType.JSON) {
                ctx.reportError("Extension ".concat(EXTENSION_NAME).concat(" is not of type JSON"));
            } else {
                JsonObject obj = ext.getJSONStructure().asJsonObject();
                this.checkStringType(ctx, obj, PROP_API_VERSION);
                this.checkStringType(ctx, obj, PROP_JAVADOC_SOURCE_LEVEL);
                this.checkStringType(ctx, obj, PROP_LICENSE_REPORT);
                this.checkStringArrayType(ctx, obj, PROP_BUNDLE_RESOURCES);
                this.checkStringArrayType(ctx, obj, PROP_BUNDLE_RESOURCE_FOLDERS);
                this.checkStringArrayType(ctx, obj, PROP_JAVADOC_CLASSPATH_TOPS);
                this.checkStringArrayType(ctx, obj, PROP_JAVADOC_CLASSPATH_HIGHEST_VERSIONS);
                this.checkStringArrayType(ctx, obj, PROP_JAVADOC_CLASSPATH_REMOVALS);
                this.checkStringArrayType(ctx, obj, "javadoc-links");
                this.checkStringArrayType(ctx, obj, PROP_LICENSE_DEFAULTS);
                this.checkStringMapType(ctx, obj, PROP_MANIFEST_ENTRIES);
                this.checkStringMapType(ctx, obj, PROP_CLASSIFIER_MAPPINGS);
                this.checkStringMapType(ctx, obj, PROP_REGION_MAPPINGS);
                this.checkStringOrStringArrayType(ctx, obj, PROP_LICENSE_FOOTER);
                this.checkStringOrStringArrayType(ctx, obj, PROP_LICENSE_HEADER);
            }
        }
    }

    private void checkStringType(AnalyserTaskContext ctx, JsonObject obj, String propName) {
        JsonValue val;
        if (obj.containsKey((Object)propName) && (val = (JsonValue)obj.get((Object)propName)).getValueType() != JsonValue.ValueType.STRING) {
            ctx.reportError("Extension ".concat(EXTENSION_NAME).concat(" : property ").concat(propName).concat(" is not of type String"));
        }
    }

    private void checkStringArrayType(AnalyserTaskContext ctx, JsonObject obj, String propName) {
        if (obj.containsKey((Object)propName)) {
            JsonValue val = (JsonValue)obj.get((Object)propName);
            if (val.getValueType() != JsonValue.ValueType.ARRAY) {
                ctx.reportError("Extension ".concat(EXTENSION_NAME).concat(" : property ").concat(propName).concat(" is not of type Array"));
            } else {
                boolean hasNonStringValue = false;
                for (JsonValue v : val.asJsonArray()) {
                    if (v.getValueType() == JsonValue.ValueType.STRING) continue;
                    hasNonStringValue = true;
                }
                if (hasNonStringValue) {
                    ctx.reportError("Extension ".concat(EXTENSION_NAME).concat(" : array ").concat(propName).concat(" contains non string values"));
                }
            }
        }
    }

    private void checkStringOrStringArrayType(AnalyserTaskContext ctx, JsonObject obj, String propName) {
        JsonValue val;
        if (obj.containsKey((Object)propName) && (val = (JsonValue)obj.get((Object)propName)).getValueType() != JsonValue.ValueType.STRING) {
            this.checkStringArrayType(ctx, obj, propName);
        }
    }

    private void checkStringMapType(AnalyserTaskContext ctx, JsonObject obj, String propName) {
        if (obj.containsKey((Object)propName)) {
            JsonValue val = (JsonValue)obj.get((Object)propName);
            if (val.getValueType() != JsonValue.ValueType.OBJECT) {
                ctx.reportError("Extension ".concat(EXTENSION_NAME).concat(" : property ").concat(propName).concat(" is not of type Object"));
            } else {
                boolean hasNonStringValue = false;
                for (JsonValue v : val.asJsonObject().values()) {
                    if (v.getValueType() == JsonValue.ValueType.STRING) continue;
                    hasNonStringValue = true;
                }
                if (hasNonStringValue) {
                    ctx.reportError("Extension ".concat(EXTENSION_NAME).concat(" : object ").concat(propName).concat(" contains non string values"));
                }
            }
        }
    }

    private void checkIdValidity(AnalyserTaskContext ctx, Artifact a, String propName) {
        String sourceId = (String)a.getMetadata().get(propName);
        if (sourceId != null) {
            Arrays.stream(sourceId.split(",")).map(String::trim).filter(el -> el.length() > 0).forEach(el -> {
                try {
                    ArtifactId.parse((String)el);
                }
                catch (IllegalArgumentException e) {
                    ctx.reportError("Bundle " + a.getId().toMvnId() + " has invalid " + propName + " entry '" + el + "' : " + e.getMessage());
                }
            });
        }
    }

    private void checkJavadocLinks(AnalyserTaskContext ctx, Artifact a) {
        String value = (String)a.getMetadata().get("javadoc-links");
        if (value != null) {
            for (String v : value.split(",")) {
                if (v.endsWith("/")) {
                    v = v.substring(0, v.length() - 1);
                }
                try {
                    new URL(v);
                }
                catch (MalformedURLException mue) {
                    ctx.reportError("Bundle " + a.getId().toMvnId() + " has invalid javadoc links URL : " + v);
                }
            }
        }
    }

    private void validateSourceInfo(AnalyserTaskContext ctx, Artifact artifact) {
        int count = 0;
        if (artifact.getMetadata().get(SCM_LOCATION) != null) {
            ++count;
        }
        if (artifact.getMetadata().get(SCM_CLASSIFIER) != null) {
            ++count;
        }
        if (artifact.getMetadata().get(SCM_IDS) != null) {
            ++count;
        }
        if (count > 1) {
            ctx.reportError("Bundle ".concat(artifact.getId().toMvnId()).concat(" should either define ").concat(SCM_LOCATION).concat(", ").concat(SCM_CLASSIFIER).concat(", or").concat(SCM_IDS).concat(" - but only one of them."));
        }
    }
}

