/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyzer.impl.felix.utils.manifest.Clause;
import org.apache.sling.feature.analyzer.impl.felix.utils.manifest.Parser;
import org.apache.sling.feature.scanner.BundleDescriptor;

public class CheckBundlesForResources
implements AnalyserTask {
    private static final String BUNDLE_RESOURCE_ROOTS = "Sling-Bundle-Resources";
    private static final String PATH_DIRECTIVE = "path";

    @Override
    public String getName() {
        return "Bundle Resources Check";
    }

    @Override
    public String getId() {
        return "bundle-resources";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            List<String> bundleResources = this.extractBundleResources(info.getManifest());
            if (bundleResources.isEmpty()) continue;
            ctx.reportWarning("Found bundle resources in " + info.getArtifact() + " : " + bundleResources);
        }
    }

    private List<String> extractBundleResources(Manifest m) {
        String root;
        ArrayList<String> bundleResources = new ArrayList<String>();
        if (m != null && (root = m.getMainAttributes().getValue(BUNDLE_RESOURCE_ROOTS)) != null) {
            Clause[] clauses;
            for (Clause entry : clauses = Parser.parseHeader(root)) {
                String resourceRoot = entry.getName();
                String pathDirective = entry.getDirective(PATH_DIRECTIVE);
                if (pathDirective != null) {
                    bundleResources.add(resourceRoot + "!" + pathDirective);
                    continue;
                }
                bundleResources.add(resourceRoot);
            }
        }
        return bundleResources;
    }
}

