/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;

public class CheckApisJarsProperties
implements AnalyserTask {
    private static final String SCM_LOCATION = "scm-location";
    private static final String API_IDS = "api-ids";
    private static final String SCM_IDS = "source-ids";
    private static final String SCM_CLASSIFIER = "source-classifier";
    private static final String JAVADOC_LINKS = "javadoc-links";

    @Override
    public String getId() {
        return "apis-jar";
    }

    @Override
    public String getName() {
        return "APIs jar properties check";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        for (Artifact artifact : ctx.getFeature().getBundles()) {
            this.validateSourceInfo(ctx, artifact);
            this.checkIdValidity(ctx, artifact, SCM_IDS);
            this.checkIdValidity(ctx, artifact, API_IDS);
            this.checkJavadocLinks(ctx, artifact);
        }
    }

    private void checkIdValidity(AnalyserTaskContext ctx, Artifact a, String propName) {
        String sourceId = (String)a.getMetadata().get(propName);
        if (sourceId != null) {
            Arrays.stream(sourceId.split(",")).map(String::trim).filter(el -> el.length() > 0).forEach(el -> {
                try {
                    ArtifactId.parse((String)el);
                }
                catch (IllegalArgumentException e) {
                    ctx.reportError("Bundle " + a.getId().toMvnId() + " has invalid " + propName + " entry '" + el + "' : " + e.getMessage());
                }
            });
        }
    }

    private void checkJavadocLinks(AnalyserTaskContext ctx, Artifact a) {
        String value = (String)a.getMetadata().get(JAVADOC_LINKS);
        if (value != null) {
            for (String v : value.split(",")) {
                if (v.endsWith("/")) {
                    v = v.substring(0, v.length() - 1);
                }
                try {
                    new URL(v);
                }
                catch (MalformedURLException mue) {
                    ctx.reportError("Bundle " + a.getId().toMvnId() + " has invalid javadoc links URL : " + v);
                }
            }
        }
    }

    private void validateSourceInfo(AnalyserTaskContext ctx, Artifact artifact) {
        int count = 0;
        if (artifact.getMetadata().get(SCM_LOCATION) != null) {
            ++count;
        }
        if (artifact.getMetadata().get(SCM_CLASSIFIER) != null) {
            ++count;
        }
        if (artifact.getMetadata().get(SCM_IDS) != null) {
            ++count;
        }
        if (count > 1) {
            ctx.reportError("Bundle ".concat(artifact.getId().toMvnId()).concat(" should either define ").concat(SCM_LOCATION).concat(", ").concat(SCM_CLASSIFIER).concat(", or").concat(SCM_IDS).concat(" - but only one of them."));
        }
    }
}

