/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.ExecutionEnvironmentExtension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.AnalyserResult;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyser.task.AnalyzerTaskProvider;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyser {
    static final String ALL_TASKS_KEY = "all";
    private final AnalyserTask[] tasks;
    private final Scanner scanner;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Map<String, String>> configurations;

    public Analyser(Scanner scanner, AnalyserTask ... tasks) throws IOException {
        this(scanner, Collections.emptyMap(), tasks);
    }

    public Analyser(Scanner scanner, Map<String, Map<String, String>> configurations, AnalyserTask ... tasks) throws IOException {
        this.tasks = tasks;
        this.configurations = configurations;
        this.scanner = scanner;
    }

    public Analyser(Scanner scanner, String ... taskClassNames) throws IOException {
        this(scanner, Collections.emptyMap(), taskClassNames);
    }

    public Analyser(Scanner scanner, Map<String, Map<String, String>> configurations, String ... taskClassNames) throws IOException {
        this(scanner, configurations, AnalyzerTaskProvider.getTasksByClassName(taskClassNames));
        if (this.tasks.length != taskClassNames.length) {
            throw new IOException("Couldn't find all tasks " + Arrays.toString(taskClassNames));
        }
    }

    public Analyser(Scanner scanner, Set<String> includes, Set<String> excludes) throws IOException {
        this(scanner, Collections.emptyMap(), includes, excludes);
    }

    public Analyser(Scanner scanner, Map<String, Map<String, String>> configurations, Set<String> includes, Set<String> excludes) throws IOException {
        this(scanner, configurations, AnalyzerTaskProvider.getTasksByIds(includes, excludes));
    }

    public Analyser(Scanner scanner) throws IOException {
        this(scanner, AnalyzerTaskProvider.getTasks());
    }

    public AnalyserResult analyse(Feature feature) throws Exception {
        return this.analyse(feature, null);
    }

    public AnalyserResult analyse(Feature feature, ArtifactId fwk) throws Exception {
        return this.analyse(feature, fwk, null);
    }

    public AnalyserResult analyse(final Feature feature, ArtifactId fwk, final FeatureProvider featureProvider) throws Exception {
        ExecutionEnvironmentExtension ext;
        this.logger.info("Starting analyzing feature '{}'...", (Object)feature.getId());
        final FeatureDescriptor featureDesc = this.scanner.scan(feature);
        BundleDescriptor bd = null;
        ArtifactId framework = fwk;
        if (framework == null && (ext = ExecutionEnvironmentExtension.getExecutionEnvironmentExtension((Feature)feature)) != null && ext.getFramework() != null) {
            framework = ext.getFramework().getId();
        }
        if (framework != null) {
            bd = this.scanner.scan(framework, feature.getFrameworkProperties());
        }
        final BundleDescriptor fwkDesc = bd;
        final ArrayList warnings = new ArrayList();
        final ArrayList errors = new ArrayList();
        for (AnalyserTask task : this.tasks) {
            this.logger.info("- Executing {} [{}]...", (Object)task.getName(), (Object)task.getId());
            final Map<String, String> taskConfiguration = this.getConfiguration(task.getId());
            task.execute(new AnalyserTaskContext(){

                @Override
                public Feature getFeature() {
                    return feature;
                }

                @Override
                public FeatureDescriptor getFeatureDescriptor() {
                    return featureDesc;
                }

                @Override
                public FeatureProvider getFeatureProvider() {
                    return featureProvider;
                }

                @Override
                public BundleDescriptor getFrameworkDescriptor() {
                    return fwkDesc;
                }

                @Override
                public Map<String, String> getConfiguration() {
                    return taskConfiguration;
                }

                @Override
                public void reportWarning(String message) {
                    warnings.add(message);
                }

                @Override
                public void reportError(String message) {
                    errors.add(message);
                }
            });
        }
        this.logger.info("Analyzing feature '" + feature.getId() + "' finished : " + warnings.size() + " warnings, " + errors.size() + " errors.");
        return new AnalyserResult(){

            @Override
            public List<String> getWarnings() {
                return warnings;
            }

            @Override
            public List<String> getErrors() {
                return errors;
            }
        };
    }

    Map<String, String> getConfiguration(String id) {
        Map<String, String> specificCfg;
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> globalCfg = this.configurations.get(ALL_TASKS_KEY);
        if (globalCfg != null) {
            result.putAll(globalCfg);
        }
        if ((specificCfg = this.configurations.get(id)) != null) {
            result.putAll(specificCfg);
        }
        return result;
    }
}

