/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.jar.Manifest;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;

public class CheckBundleNativeCode
implements AnalyserTask {
    @Override
    public String getName() {
        return "Bundle Natice Code Check";
    }

    @Override
    public String getId() {
        return "bundle-nativecode";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) {
        for (BundleDescriptor descriptor : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            Manifest mf = descriptor.getManifest();
            String nativeCode = mf.getMainAttributes().getValue("Bundle-NativeCode");
            if (nativeCode == null) continue;
            ctx.reportArtifactError(descriptor.getArtifact().getId(), "Found native code instruction in bundle: ".concat(nativeCode));
        }
    }
}

