/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.impl.ContentPackageDescriptor;

public class CheckContentPackagesForPaths
implements AnalyserTask {
    private static final String PROP_INCLUDES = "includes";
    private static final String PROP_EXCLUDES = "excludes";

    @Override
    public String getName() {
        return "Content Packages Path Check";
    }

    @Override
    public String getId() {
        return "content-packages-paths";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        Rules rules = this.getRules(ctx);
        if (rules != null) {
            for (ArtifactDescriptor d : ctx.getFeatureDescriptor().getArtifactDescriptors()) {
                if (!(d instanceof ContentPackageDescriptor)) continue;
                this.checkPackage(ctx, (ContentPackageDescriptor)d, rules);
            }
        } else {
            ctx.reportError("Configuration for task " + this.getId() + " is missing.");
        }
    }

    Rules getRules(AnalyserTaskContext ctx) {
        String inc = ctx.getConfiguration().get(PROP_INCLUDES);
        String exc = ctx.getConfiguration().get(PROP_EXCLUDES);
        if (inc != null || exc != null) {
            Rules r = new Rules();
            r.includes = inc == null ? null : inc.split(",");
            CheckContentPackagesForPaths.clean(r.includes);
            r.excludes = exc == null ? null : exc.split(",");
            CheckContentPackagesForPaths.clean(r.excludes);
            return r;
        }
        return null;
    }

    private static void clean(String[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = array[i].trim();
            }
        }
    }

    void checkPackage(AnalyserTaskContext ctx, ContentPackageDescriptor desc, Rules rules) {
        for (String path : desc.paths) {
            boolean isAllowed = rules.includes == null;
            int matchLength = 0;
            if (!isAllowed) {
                for (String i : rules.includes) {
                    if (!path.equals(i) && !path.startsWith(i.concat("/"))) continue;
                    isAllowed = true;
                    matchLength = i.length();
                    break;
                }
            }
            if (isAllowed && rules.excludes != null) {
                for (String i : rules.excludes) {
                    if (!path.equals(i) && (!path.startsWith(i.concat("/")) || i.length() <= matchLength)) continue;
                    isAllowed = false;
                    break;
                }
            }
            if (isAllowed) continue;
            ctx.reportArtifactError(desc.getArtifact().getId(), "Content not allowed: ".concat(path));
        }
    }

    static final class Rules {
        public String[] includes;
        public String[] excludes;

        Rules() {
        }
    }
}

