/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XmlAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(XmlAnalyzer.class);

    private XmlAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerializationType analyze(InputSource source) throws IOException {
        Reader r = source.getCharacterStream();
        SerializationType type = SerializationType.UNKOWN;
        if (r == null) {
            r = source.getEncoding() == null ? new InputStreamReader(source.getByteStream()) : new InputStreamReader(source.getByteStream(), source.getEncoding());
        }
        try {
            int pos;
            int read;
            char[] buffer = new char[1024];
            for (pos = 0; pos < buffer.length && (read = r.read(buffer, pos, buffer.length - pos)) >= 0; pos += read) {
            }
            String str = new String(buffer, 0, pos);
            type = str.contains("<jcr:root") && str.contains("\"http://www.jcp.org/jcr/1.0\"") ? SerializationType.XML_DOCVIEW : (str.contains("<?xml ") ? SerializationType.XML_GENERIC : SerializationType.GENERIC);
        }
        finally {
            IOUtils.closeQuietly(r);
        }
        log.trace("Analyzed {}. Type = {}", (Object)source.getSystemId(), (Object)type);
        return type;
    }
}

