/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlan;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import org.apache.jackrabbit.vault.packaging.registry.impl.PackageTaskImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionPlanImpl
implements ExecutionPlan {
    private static final Logger log = LoggerFactory.getLogger(ExecutionPlanImpl.class);
    private List<PackageTask> tasks = new ArrayList<PackageTask>();
    private String id;
    private PackageRegistry registry;
    private ProgressTrackerListener listener;
    private Session session;

    public ExecutionPlanImpl(List<PackageTask> tasks) {
        this.tasks.addAll(tasks);
    }

    @Override
    public List<PackageTask> getTasks() {
        return this.tasks;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    ExecutionPlanImpl setId(String id) {
        this.id = id;
        return this;
    }

    ExecutionPlanImpl with(PackageRegistry registry) {
        this.registry = registry;
        return this;
    }

    ExecutionPlanImpl with(Session session) {
        this.session = session;
        return this;
    }

    ExecutionPlanImpl with(ProgressTrackerListener listener) {
        this.listener = listener;
        return this;
    }

    PackageRegistry getRegistry() {
        return this.registry;
    }

    ProgressTrackerListener getListener() {
        return this.listener;
    }

    Session getSession() {
        return this.session;
    }

    @Override
    public boolean isExecuted() {
        for (PackageTask task : this.tasks) {
            if (task.getState() == PackageTask.State.COMPLETED || task.getState() == PackageTask.State.ERROR) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasErrors() {
        for (PackageTask task : this.tasks) {
            if (task.getState() != PackageTask.State.ERROR) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public ExecutionPlan execute() throws IOException, PackageException {
        if (this.isExecuted()) {
            log.warn("executing plan that was already executed.");
            return this;
        }
        for (PackageTask task : this.tasks) {
            if (task instanceof PackageTaskImpl) {
                ((PackageTaskImpl)task).execute(this);
                continue;
            }
            throw new PackageException("task class " + task.getClass().getName() + " is not supported.");
        }
        return this;
    }
}

