/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.util.Text;
import org.w3c.dom.Element;

public class ScopedWorkspaceFilter
extends DefaultWorkspaceFilter {
    private static final String[] APP_ROOTS = new String[]{"/apps", "/libs"};
    private final DefaultWorkspaceFilter base;
    private final boolean allow;
    private final String[] roots;
    private final List<PathFilterSet> nodesFilterSets;
    private final List<PathFilterSet> propsFilterSets;

    public ScopedWorkspaceFilter(DefaultWorkspaceFilter base, boolean allow, String[] roots) {
        String root;
        this.base = base;
        this.allow = allow;
        this.roots = roots;
        ArrayList<PathFilterSet> nodesFilterSets = new ArrayList<PathFilterSet>();
        ArrayList<PathFilterSet> propsFilterSets = new ArrayList<PathFilterSet>();
        for (PathFilterSet set : base.getFilterSets()) {
            root = set.getRoot();
            if (!"/".equals(root) && !this.match(root)) continue;
            nodesFilterSets.add(set);
        }
        for (PathFilterSet set : base.getPropertyFilterSets()) {
            root = set.getRoot();
            if (!"/".equals(root) && !this.match(root)) continue;
            propsFilterSets.add(set);
        }
        this.nodesFilterSets = Collections.unmodifiableList(nodesFilterSets);
        this.propsFilterSets = Collections.unmodifiableList(propsFilterSets);
    }

    private boolean match(String path) {
        if (this.allow) {
            for (String root : this.roots) {
                if (!Text.isDescendantOrEqual(root, path)) continue;
                return true;
            }
            return false;
        }
        for (String root : this.roots) {
            if (!Text.isDescendantOrEqual(root, path)) continue;
            return false;
        }
        return true;
    }

    public static ScopedWorkspaceFilter createApplicationScoped(DefaultWorkspaceFilter base) {
        return new ScopedWorkspaceFilter(base, true, APP_ROOTS);
    }

    public static ScopedWorkspaceFilter createContentScoped(DefaultWorkspaceFilter base) {
        return new ScopedWorkspaceFilter(base, false, APP_ROOTS);
    }

    @Override
    public void add(PathFilterSet set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(PathFilterSet nodeFilter, PathFilterSet propFilter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPropertyFilterSet(PathFilterSet set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PathFilterSet> getFilterSets() {
        return this.nodesFilterSets;
    }

    @Override
    public List<PathFilterSet> getPropertyFilterSets() {
        return this.propsFilterSets;
    }

    @Override
    public PathFilterSet getCoveringFilterSet(String path) {
        if (!this.match(path)) {
            return null;
        }
        return this.base.getCoveringFilterSet(path);
    }

    @Override
    public ImportMode getImportMode(String path) {
        return this.base.getImportMode(path);
    }

    @Override
    public void setImportMode(ImportMode importMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(String path) {
        return this.match(path) && this.base.contains(path);
    }

    @Override
    public boolean covers(String path) {
        return this.match(path) && this.base.covers(path);
    }

    @Override
    public boolean isAncestor(String path) {
        for (PathFilterSet set : this.nodesFilterSets) {
            if (!set.isAncestor(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGloballyIgnored(String path) {
        return this.base.isGloballyIgnored(path);
    }

    @Override
    public WorkspaceFilter translate(PathMapping mapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void load(File file) throws IOException, ConfigurationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourceAsString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void load(InputStream in) throws IOException, ConfigurationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected PathFilter readFilter(Element elem) throws ConfigurationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGlobalIgnored(PathFilter ignored) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpCoverage(Node rootNode, ProgressTrackerListener listener) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpCoverage(Session session, ProgressTrackerListener listener, boolean skipJcrContent) throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

