/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.Archive;

public final class ArchiveWrapper
implements Archive {
    private final Archive archive;

    public ArchiveWrapper(Archive archive) {
        this.archive = archive;
    }

    @Override
    public void open(boolean strict) throws IOException {
        this.archive.open(strict);
    }

    @Override
    @CheckForNull
    public InputStream openInputStream(@Nullable Archive.Entry entry) throws IOException {
        return this.archive.openInputStream(entry);
    }

    @Override
    @CheckForNull
    public VaultInputSource getInputSource(@Nullable Archive.Entry entry) throws IOException {
        return this.archive.getInputSource(entry);
    }

    @Override
    @CheckForNull
    public Archive.Entry getJcrRoot() throws IOException {
        return this.archive.getJcrRoot();
    }

    @Override
    @Nonnull
    public Archive.Entry getRoot() throws IOException {
        return this.archive.getRoot();
    }

    @Override
    @Nonnull
    public MetaInf getMetaInf() {
        return this.archive.getMetaInf();
    }

    @Override
    @CheckForNull
    public Archive.Entry getEntry(@Nonnull String path) throws IOException {
        return this.archive.getEntry(path);
    }

    @Override
    @CheckForNull
    public Archive getSubArchive(@Nonnull String root, boolean asJcrRoot) throws IOException {
        return this.archive.getSubArchive(root, asJcrRoot);
    }

    @Override
    public void close() {
        this.archive.close();
    }
}

