/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.ExecutionEnvironmentExtension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.AnalyserResult;
import org.apache.sling.feature.analyser.extensions.AnalyserMetaDataExtension;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyser.task.AnalyzerTaskProvider;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyser {
    static final String ALL_TASKS_KEY = "all";
    private final AnalyserTask[] tasks;
    private final Scanner scanner;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Map<String, String>> configurations;

    public Analyser(Scanner scanner, AnalyserTask ... tasks) throws IOException {
        this(scanner, Collections.emptyMap(), tasks);
    }

    public Analyser(Scanner scanner, Map<String, Map<String, String>> configurations, AnalyserTask ... tasks) throws IOException {
        this.tasks = tasks;
        this.configurations = configurations;
        this.scanner = scanner;
    }

    public Analyser(Scanner scanner, String ... taskClassNames) throws IOException {
        this(scanner, Collections.emptyMap(), taskClassNames);
    }

    public Analyser(Scanner scanner, Map<String, Map<String, String>> configurations, String ... taskClassNames) throws IOException {
        this(scanner, configurations, AnalyzerTaskProvider.getTasksByClassName(taskClassNames));
        if (this.tasks.length != taskClassNames.length) {
            throw new IOException("Couldn't find all tasks " + Arrays.toString(taskClassNames));
        }
    }

    public Analyser(Scanner scanner, Set<String> includes, Set<String> excludes) throws IOException {
        this(scanner, Collections.emptyMap(), includes, excludes);
    }

    public Analyser(Scanner scanner, Map<String, Map<String, String>> configurations, Set<String> includes, Set<String> excludes) throws IOException {
        this(scanner, configurations, AnalyzerTaskProvider.getTasksByIds(includes, excludes));
    }

    public Analyser(Scanner scanner) throws IOException {
        this(scanner, AnalyzerTaskProvider.getTasks());
    }

    public AnalyserResult analyse(Feature feature) throws Exception {
        return this.analyse(feature, null);
    }

    public AnalyserResult analyse(Feature feature, ArtifactId fwk) throws Exception {
        return this.analyse(feature, fwk, null);
    }

    public AnalyserResult analyse(final Feature feature, ArtifactId fwk, final FeatureProvider featureProvider) throws Exception {
        ExecutionEnvironmentExtension ext;
        this.logger.info("Starting analyzing feature '{}'...", (Object)feature.getId());
        final FeatureDescriptor featureDesc = this.scanner.scan(feature);
        BundleDescriptor bd = null;
        ArtifactId framework = fwk;
        if (framework == null && (ext = ExecutionEnvironmentExtension.getExecutionEnvironmentExtension((Feature)feature)) != null && ext.getFramework() != null) {
            framework = ext.getFramework().getId();
        }
        if (framework != null) {
            bd = this.scanner.scan(framework, feature.getFrameworkProperties());
        }
        final BundleDescriptor fwkDesc = bd;
        final ArrayList globalWarnings = new ArrayList();
        final ArrayList artifactWarnings = new ArrayList();
        final ArrayList extensionWarnings = new ArrayList();
        final ArrayList configurationWarnings = new ArrayList();
        final ArrayList globalErrors = new ArrayList();
        final ArrayList artifactErrors = new ArrayList();
        final ArrayList extensionErrors = new ArrayList();
        final ArrayList configurationErrors = new ArrayList();
        final AnalyserMetaDataExtension analyserMetaDataExtension = AnalyserMetaDataExtension.getAnalyserMetaDataExtension(feature);
        for (AnalyserTask task : this.tasks) {
            this.logger.info("- Executing {} [{}]...", (Object)task.getName(), (Object)task.getId());
            final Map<String, String> taskConfiguration = this.getConfiguration(task.getId());
            task.execute(new AnalyserTaskContext(){
                private final FeatureProvider cachingFeatureProvider;
                {
                    this.cachingFeatureProvider = featureProvider != null ? new FeatureProvider(){
                        private final ConcurrentHashMap<ArtifactId, Feature> cache = new ConcurrentHashMap();

                        public Feature provide(ArtifactId artifactId) {
                            return this.cache.computeIfAbsent(artifactId, key -> featureProvider.provide(artifactId));
                        }
                    } : null;
                }

                @Override
                public Feature getFeature() {
                    return feature;
                }

                @Override
                public FeatureDescriptor getFeatureDescriptor() {
                    return featureDesc;
                }

                @Override
                public FeatureProvider getFeatureProvider() {
                    return this.cachingFeatureProvider;
                }

                @Override
                public BundleDescriptor getFrameworkDescriptor() {
                    return fwkDesc;
                }

                @Override
                public Map<String, String> getConfiguration() {
                    return taskConfiguration;
                }

                @Override
                public void reportWarning(String message) {
                    if (analyserMetaDataExtension == null || analyserMetaDataExtension.reportWarning(feature.getId())) {
                        globalWarnings.add(new AnalyserResult.GlobalReport(message));
                    }
                }

                @Override
                public void reportArtifactWarning(ArtifactId artifactId, String message) {
                    if (analyserMetaDataExtension == null || analyserMetaDataExtension.reportWarning(artifactId) && analyserMetaDataExtension.reportWarning(feature.getId())) {
                        artifactWarnings.add(new AnalyserResult.ArtifactReport(artifactId, message));
                    }
                }

                @Override
                public void reportArtifactError(ArtifactId artifactId, String message) {
                    if (analyserMetaDataExtension == null || analyserMetaDataExtension.reportError(artifactId) && analyserMetaDataExtension.reportError(feature.getId())) {
                        artifactErrors.add(new AnalyserResult.ArtifactReport(artifactId, message));
                    }
                }

                @Override
                public void reportExtensionWarning(String extension, String message) {
                    if (analyserMetaDataExtension == null || analyserMetaDataExtension.reportWarning(feature.getId())) {
                        extensionWarnings.add(new AnalyserResult.ExtensionReport(extension, message));
                    }
                }

                @Override
                public void reportExtensionError(String extension, String message) {
                    if (analyserMetaDataExtension == null || analyserMetaDataExtension.reportError(feature.getId())) {
                        extensionErrors.add(new AnalyserResult.ExtensionReport(extension, message));
                    }
                }

                @Override
                public void reportError(String message) {
                    if (analyserMetaDataExtension == null || analyserMetaDataExtension.reportError(feature.getId())) {
                        globalErrors.add(new AnalyserResult.GlobalReport(message));
                    }
                }

                @Override
                public void reportConfigurationError(Configuration cfg, String message) {
                    if (analyserMetaDataExtension == null || analyserMetaDataExtension.reportWarning(feature.getId())) {
                        configurationErrors.add(new AnalyserResult.ConfigurationReport(cfg, message));
                    }
                }

                @Override
                public void reportConfigurationWarning(Configuration cfg, String message) {
                    if (analyserMetaDataExtension == null || analyserMetaDataExtension.reportWarning(feature.getId())) {
                        configurationWarnings.add(new AnalyserResult.ConfigurationReport(cfg, message));
                    }
                }
            });
        }
        int allWarnings = globalWarnings.size() + artifactWarnings.size() + extensionWarnings.size();
        int allErrors = globalErrors.size() + artifactErrors.size() + extensionErrors.size();
        this.logger.info("Analyzing feature '" + feature.getId() + "' finished : " + allWarnings + " warnings, " + allErrors + " errors.");
        return new AnalyserResult(){

            @Override
            public List<AnalyserResult.GlobalReport> getGlobalWarnings() {
                return globalWarnings;
            }

            @Override
            public List<AnalyserResult.ArtifactReport> getArtifactWarnings() {
                return artifactWarnings;
            }

            @Override
            public List<AnalyserResult.ExtensionReport> getExtensionWarnings() {
                return extensionWarnings;
            }

            @Override
            public List<AnalyserResult.GlobalReport> getGlobalErrors() {
                return globalErrors;
            }

            @Override
            public List<AnalyserResult.ArtifactReport> getArtifactErrors() {
                return artifactErrors;
            }

            @Override
            public List<AnalyserResult.ExtensionReport> getExtensionErrors() {
                return extensionErrors;
            }

            @Override
            public FeatureDescriptor getFeatureDescriptor() {
                return featureDesc;
            }

            @Override
            public BundleDescriptor getFrameworkDescriptor() {
                return fwkDesc;
            }

            @Override
            public List<AnalyserResult.ConfigurationReport> getConfigurationErrors() {
                return configurationErrors;
            }

            @Override
            public List<AnalyserResult.ConfigurationReport> getConfigurationWarnings() {
                return configurationWarnings;
            }
        };
    }

    Map<String, String> getConfiguration(String id) {
        Map<String, String> specificCfg;
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> globalCfg = this.configurations.get(ALL_TASKS_KEY);
        if (globalCfg != null) {
            result.putAll(globalCfg);
        }
        if ((specificCfg = this.configurations.get(id)) != null) {
            result.putAll(specificCfg);
        }
        return result;
    }
}

