/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.scanner.impl.BundleDescriptorImpl;
import org.apache.sling.feature.scanner.impl.ContentPackageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentPackageScanner {
    private static final Logger logger = LoggerFactory.getLogger(ContentPackageScanner.class);
    private final byte[] buffer = new byte[65536];

    public Set<ContentPackageDescriptor> scan(Artifact desc, URL file) throws IOException {
        HashSet<ContentPackageDescriptor> contentPackages = new HashSet<ContentPackageDescriptor>();
        if (file != null) {
            ContentPackageDescriptor cp = new ContentPackageDescriptor(file.getPath());
            int lastDot = file.getPath().lastIndexOf(".");
            cp.setName(file.getPath().substring(file.getPath().lastIndexOf("/") + 1, lastDot));
            cp.setArtifact(desc);
            cp.setArtifactFile(file);
            this.extractContentPackage(cp, contentPackages, file);
            contentPackages.add(cp);
            cp.lock();
        }
        return contentPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractContentPackage(ContentPackageDescriptor cp, Set<ContentPackageDescriptor> infos, URL archive) throws IOException {
        logger.debug("Analyzing Content Package {}", (Object)archive);
        File tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        try {
            File toDir = new File(tempDir, archive.getPath().substring(archive.getPath().lastIndexOf("/") + 1));
            toDir.mkdirs();
            ArrayList<File> toProcess = new ArrayList<File>();
            try (JarFile zipFile = IOUtils.getJarFileFromURL((URL)archive, (boolean)true, null);){
                Enumeration<JarEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    logger.debug("Content package entry {}", (Object)entryName);
                    if (entryName.endsWith("/") || !entryName.startsWith("jcr_root/")) continue;
                    String contentPath = entryName.substring(8);
                    FileType fileType = null;
                    if (entryName.endsWith(".zip")) {
                        fileType = FileType.PACKAGE;
                    } else if (entryName.startsWith("jcr_root/libs/") || entryName.startsWith("jcr_root/apps/")) {
                        int endSlashPos;
                        int pos;
                        boolean isInstall;
                        boolean bl = isInstall = entryName.indexOf("/install/") != -1;
                        if (!isInstall && (pos = entryName.indexOf("/install.")) != -1 && (endSlashPos = entryName.indexOf(47, pos + 1)) != -1) {
                            isInstall = true;
                        }
                        if (!isInstall) {
                            boolean bl2 = isInstall = entryName.indexOf("/config/") != -1;
                            if (!isInstall && (pos = entryName.indexOf("/config.")) != -1 && (endSlashPos = entryName.indexOf(47, pos + 1)) != -1) {
                                isInstall = true;
                            }
                        }
                        if (isInstall) {
                            if (entryName.endsWith(".jar")) {
                                fileType = FileType.BUNDLE;
                            } else if (entryName.endsWith(".xml") || entryName.endsWith(".config")) {
                                fileType = FileType.CONFIG;
                            }
                        }
                    }
                    if (fileType == null) continue;
                    logger.debug("- extracting : {}", (Object)entryName);
                    File newFile = new File(toDir, entryName.replace('/', File.separatorChar));
                    newFile.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(newFile);
                         InputStream zis = zipFile.getInputStream(entry);){
                        int len;
                        while ((len = zis.read(this.buffer)) > -1) {
                            fos.write(this.buffer, 0, len);
                        }
                    }
                    if (fileType == FileType.BUNDLE) {
                        int startLevel = 20;
                        int lastSlash = contentPath.lastIndexOf(47);
                        int nextSlash = contentPath.lastIndexOf(47, lastSlash - 1);
                        String part = contentPath.substring(nextSlash + 1, lastSlash);
                        try {
                            startLevel = Integer.valueOf(part);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        Artifact bundle = new Artifact(this.extractArtifactId(tempDir, newFile));
                        bundle.setStartOrder(startLevel);
                        BundleDescriptorImpl info = new BundleDescriptorImpl(bundle, newFile.toURI().toURL(), startLevel);
                        bundle.getMetadata().put("content-package", cp.getArtifact().getId().toMvnId());
                        bundle.getMetadata().put("content-path", contentPath);
                        cp.bundles.add(info);
                        continue;
                    }
                    if (fileType == FileType.CONFIG) {
                        Configuration configEntry = this.process(newFile, cp.getArtifact(), contentPath);
                        if (configEntry == null) continue;
                        cp.configs.add(configEntry);
                        continue;
                    }
                    if (fileType != FileType.PACKAGE) continue;
                    toProcess.add(newFile);
                }
                for (File f : toProcess) {
                    this.extractContentPackage(cp, infos, f.toURI().toURL());
                    ContentPackageDescriptor i = new ContentPackageDescriptor(f.getName());
                    int lastDot = f.getName().lastIndexOf(".");
                    i.setName(f.getName().substring(0, lastDot));
                    i.setArtifactFile(f.toURI().toURL());
                    i.setContentPackageInfo(cp.getArtifact(), f.getName());
                    infos.add(i);
                    i.lock();
                }
            }
        }
        finally {
            this.deleteOnExitRecursive(tempDir);
        }
    }

    private void deleteOnExitRecursive(File file) {
        File[] childs;
        file.deleteOnExit();
        if (file.isDirectory() && (childs = file.listFiles()) != null) {
            for (File child : childs) {
                this.deleteOnExitRecursive(child);
            }
        }
    }

    private ArtifactId extractArtifactId(File tempDir, File bundleFile) throws IOException {
        File mavenDir;
        logger.debug("Extracting Bundle {}", (Object)bundleFile.getName());
        File toDir = new File(tempDir, bundleFile.getName());
        toDir.mkdirs();
        try (JarFile zipFile = new JarFile(bundleFile);){
            Enumeration<JarEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File[] entryName = entry.getName();
                if (entryName.endsWith("/") || !entryName.startsWith("META-INF/maven/") || !entryName.endsWith("/pom.properties")) continue;
                logger.debug("- extracting : {}", (Object)entryName);
                File newFile = new File(toDir, entryName.replace('/', File.separatorChar));
                newFile.getParentFile().mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    InputStream zis = zipFile.getInputStream(entry);
                    try {
                        int len;
                        while ((len = zis.read(this.buffer)) > -1) {
                            fos.write(this.buffer, 0, len);
                        }
                    }
                    finally {
                        if (zis == null) continue;
                        zis.close();
                    }
                }
            }
        }
        File metaInfDir = new File(toDir, "META-INF");
        if (metaInfDir.exists() && (mavenDir = new File(metaInfDir, "maven")).exists()) {
            File groupDir = null;
            for (File d : mavenDir.listFiles()) {
                if (!d.isDirectory() || d.getName().startsWith(".")) continue;
                groupDir = d;
                break;
            }
            if (groupDir != null) {
                File propsFile;
                File artifactDir = null;
                for (File d : groupDir.listFiles()) {
                    if (!d.isDirectory() || d.getName().startsWith(".")) continue;
                    artifactDir = d;
                    break;
                }
                if (artifactDir != null && (propsFile = new File(artifactDir, "pom.properties")).exists()) {
                    String[] parts;
                    Properties props = new Properties();
                    try (FileReader r = new FileReader(propsFile);){
                        props.load(r);
                    }
                    String groupId = props.getProperty("groupId");
                    String artifactId = props.getProperty("artifactId");
                    String version = props.getProperty("version");
                    String classifier = null;
                    int pos = bundleFile.getName().indexOf(version) + version.length();
                    if (bundleFile.getName().charAt(pos) == '-') {
                        classifier = bundleFile.getName().substring(pos + 1, bundleFile.getName().lastIndexOf(46));
                    }
                    if ((parts = version.split("\\.")).length == 4) {
                        int lastDot = version.lastIndexOf(46);
                        version = version.substring(0, lastDot) + '-' + version.substring(lastDot + 1);
                    }
                    if (groupId != null && artifactId != null && version != null) {
                        return new ArtifactId(groupId, artifactId, version, classifier, null);
                    }
                }
            }
        }
        throw new IOException(bundleFile.getName() + " has no maven coordinates!");
    }

    private Configuration process(File configFile, Artifact packageArtifact, String contentPath) throws IOException {
        String contents;
        boolean isConfig = true;
        if (configFile.getName().endsWith(".xml") && (contents = Files.readAllLines(configFile.toPath()).toString()).indexOf("jcr:primaryType=\"sling:OsgiConfig\"") == -1) {
            isConfig = false;
        }
        if (isConfig) {
            String id;
            if (".content.xml".equals(configFile.getName())) {
                int lastSlash = contentPath.lastIndexOf(47);
                int previousSlash = contentPath.lastIndexOf(47, lastSlash - 1);
                id = contentPath.substring(previousSlash + 1, lastSlash);
            } else {
                int lastDot = configFile.getName().lastIndexOf(46);
                id = configFile.getName().substring(0, lastDot);
            }
            int slashPos = id.indexOf(45);
            String pid = slashPos == -1 ? id : id.substring(0, slashPos) + '~' + id.substring(slashPos + 1);
            Configuration cfg = new Configuration(pid);
            cfg.getProperties().put(":configurator:feature-content-path", contentPath);
            cfg.getProperties().put(":configurator:feature-content-package", packageArtifact.getId().toMvnId());
            return cfg;
        }
        return null;
    }

    private static enum FileType {
        BUNDLE,
        CONFIG,
        PACKAGE;

    }
}

