/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface AnalyserResult {
    default public List<String> getWarnings() {
        return Stream.of(this.getGlobalWarnings().stream().map(Report::getValue), this.getArtifactWarnings().stream().map(report -> report.getKey() + ": " + report.getValue()), this.getExtensionWarnings().stream().map(report -> (String)report.getKey() + ": " + report.getValue())).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public List<GlobalReport> getGlobalWarnings();

    public List<ArtifactReport> getArtifactWarnings();

    public List<ExtensionReport> getExtensionWarnings();

    default public List<String> getErrors() {
        return Stream.of(this.getGlobalErrors().stream().map(Report::getValue), this.getArtifactErrors().stream().map(report -> report.getKey() + ": " + report.getValue()), this.getExtensionErrors().stream().map(report -> (String)report.getKey() + ": " + report.getValue())).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public List<GlobalReport> getGlobalErrors();

    public List<ArtifactReport> getArtifactErrors();

    public List<ExtensionReport> getExtensionErrors();

    public FeatureDescriptor getFeatureDescriptor();

    public BundleDescriptor getFrameworkDescriptor();

    public static class GlobalReport
    extends Report<Void> {
        GlobalReport(String value) {
            super(null, value);
        }
    }

    public static class ExtensionReport
    extends Report<String> {
        ExtensionReport(String key, String value) {
            super(key, value);
        }
    }

    public static class ArtifactReport
    extends Report<ArtifactId> {
        ArtifactReport(ArtifactId key, String value) {
            super(key, value);
        }
    }

    public static class Report<T> {
        private final T key;
        private final String value;

        Report(T key, String value) {
            this.key = key;
            this.value = value;
        }

        public T getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

