/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyzer.impl.felix.utils.manifest.Parser;
import org.apache.sling.feature.analyzer.impl.felix.utils.resource.ResourceBuilder;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.apache.sling.feature.scanner.impl.fwk.FrameworkPropertiesGatherer;
import org.apache.sling.feature.scanner.spi.FrameworkScanner;
import org.osgi.resource.Capability;

public class FelixFrameworkScanner
implements FrameworkScanner {
    @Override
    public BundleDescriptor scan(final ArtifactId framework, Map<String, String> frameworkProps, ArtifactProvider provider) throws IOException {
        final URL platformFile = provider.provide(framework);
        if (platformFile == null) {
            throw new IOException("Unable to find file for " + framework.toMvnId());
        }
        Map<String, String> fwkProps = this.getFrameworkProperties(frameworkProps, platformFile);
        if (fwkProps == null) {
            return null;
        }
        Set<PackageInfo> pcks = this.calculateSystemPackages(fwkProps);
        List<Capability> capabilities = this.calculateSystemCapabilities(fwkProps);
        BundleDescriptor d = new BundleDescriptor(framework.toMvnId()){

            @Override
            public String getBundleSymbolicName() {
                return "system.bundle";
            }

            @Override
            public String getBundleVersion() {
                return framework.getOSGiVersion().toString();
            }

            @Override
            public int getBundleStartLevel() {
                return 0;
            }

            @Override
            public URL getArtifactFile() {
                return platformFile;
            }

            @Override
            public Artifact getArtifact() {
                return new Artifact(framework);
            }

            @Override
            public Manifest getManifest() {
                return new Manifest();
            }
        };
        d.getCapabilities().addAll(capabilities);
        d.getExportedPackages().addAll(pcks);
        d.lock();
        return d;
    }

    private List<Capability> calculateSystemCapabilities(Map<String, String> fwkProps) throws IOException {
        HashMap<String, String> mf = new HashMap<String, String>();
        mf.put("Provide-Capability", fwkProps.get("org.osgi.framework.system.capabilities"));
        mf.put("Bundle-SymbolicName", "system.bundle");
        mf.put("Bundle-ManifestVersion", "2");
        try {
            return ResourceBuilder.build(null, mf).getCapabilities(null);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private Set<PackageInfo> calculateSystemPackages(Map<String, String> fwkProps) {
        return Stream.of(Parser.parseHeader(fwkProps.get("org.osgi.framework.system.packages"))).map(clause -> new PackageInfo(clause.getName(), clause.getAttribute("version") != null ? clause.getAttribute("version") : "0.0.0", false)).collect(Collectors.toSet());
    }

    Map<String, String> getFrameworkProperties(Map<String, String> appProps, URL framework) throws IOException {
        Path appPropsFile = Files.createTempFile("appProps", ".properties", new FileAttribute[0]);
        Properties appPropsProperties = new Properties();
        for (Map.Entry<String, String> entry : appProps.entrySet()) {
            appPropsProperties.put(entry.getKey(), entry.getValue().replace("{dollar}", "$"));
        }
        try (FileWriter writer = new FileWriter(appPropsFile.toFile());){
            appPropsProperties.store(writer, "appProps");
        }
        File frameworkJar = IOUtils.getFileFromURL((URL)framework, (boolean)true, null);
        File gathererCP = this.getGathererClassPath();
        Path outFile = Files.createTempFile("frameworkCaps", ".properties", new FileAttribute[0]);
        Path runDir = Files.createTempDirectory("frameworkCaps", new FileAttribute[0]);
        List<String> commandLine = Arrays.asList("-cp", gathererCP + File.pathSeparator + frameworkJar.getAbsolutePath(), FrameworkPropertiesGatherer.class.getName(), appPropsFile.toString(), outFile.toString());
        try {
            FelixFrameworkScanner.runJava(new ArrayList<String>(commandLine), runDir);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        Properties gatheredProps = new Properties();
        try (FileReader reader = new FileReader(outFile.toFile());){
            gatheredProps.load(reader);
        }
        Files.delete(appPropsFile);
        Files.delete(outFile);
        try (Stream<Path> fileStream = Files.walk(runDir, new FileVisitOption[0]);){
            fileStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        return gatheredProps;
    }

    private File getGathererClassPath() throws IOException {
        return FelixFrameworkScanner.getClasspathForClass(FrameworkPropertiesGatherer.class);
    }

    static File getClasspathForClass(Class<?> cls) throws IOException {
        String clsName = cls.getName();
        String resName = "/" + clsName.replace('.', '/') + ".class";
        URL resource = cls.getResource(resName);
        String resURL = URLDecoder.decode(resource.toString(), StandardCharsets.UTF_8.name());
        if (!resURL.startsWith("jar:file:")) {
            String urlFile = resource.getFile();
            return new File(urlFile.substring(0, urlFile.length() - resName.length()));
        }
        int pingSlash = resURL.indexOf("!/");
        String fileURL = resURL.substring("jar:".length(), pingSlash);
        return new File(new URL(fileURL).getFile());
    }

    private static void runJava(List<String> commandLine, Path execDir) throws IOException, InterruptedException {
        String java = System.getProperty("java.home") + "/bin/java";
        commandLine.add(0, java);
        FelixFrameworkScanner.runCommand(commandLine, execDir);
    }

    private static void runCommand(List<String> commandLine, Path execDir) throws IOException, InterruptedException {
        Process process = new ProcessBuilder(commandLine).directory(execDir.toFile()).inheritIO().start();
        int res = process.waitFor();
        if (res != 0) {
            throw new IOException("Process returned with a failure: " + res);
        }
    }
}

