/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.analyzer.impl.felix.utils.manifest.Clause;
import org.apache.sling.feature.analyzer.impl.felix.utils.manifest.Parser;
import org.apache.sling.feature.analyzer.impl.felix.utils.resource.ResourceBuilder;
import org.apache.sling.feature.analyzer.impl.felix.utils.resource.ResourceImpl;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.apache.sling.feature.scanner.impl.MatchingRequirementImpl;
import org.osgi.resource.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDescriptorImpl
extends BundleDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(BundleDescriptorImpl.class);
    private final ArtifactProvider artifactProvider;
    private String symbolicName;
    private String bundleVersion;
    private final int startLevel;
    private final Manifest manifest;
    private final URL artifactFile;
    private final Artifact artifact;

    private static Manifest getManifest(URL file) throws IOException {
        try (JarFile jarFile = IOUtils.getJarFileFromURL((URL)file, (boolean)true, null);){
            Manifest manifest = jarFile.getManifest();
            return manifest;
        }
    }

    public BundleDescriptorImpl(Artifact a, URL file, int startLevel) throws IOException {
        this(a, file, null, BundleDescriptorImpl.getManifest(file), startLevel);
    }

    public BundleDescriptorImpl(Artifact a, ArtifactProvider provider, Manifest manifest, int startLevel) throws IOException {
        this(a, null, provider, manifest, startLevel);
    }

    public BundleDescriptorImpl(Artifact a, URL file, ArtifactProvider provider, Manifest manifest, int startLevel) throws IOException {
        super(a.getId().toMvnId());
        this.artifact = a;
        this.startLevel = startLevel;
        this.artifactFile = file;
        this.artifactProvider = provider;
        if (manifest == null) {
            throw new IOException("File has no manifest");
        }
        this.manifest = new Manifest(manifest);
        this.analyze();
        this.lock();
    }

    @Override
    public String getBundleSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public String getBundleVersion() {
        return this.bundleVersion;
    }

    @Override
    public int getBundleStartLevel() {
        return this.startLevel;
    }

    @Override
    public URL getArtifactFile() {
        URL result = null;
        if (this.artifactFile == null && this.artifactProvider != null) {
            try {
                result = this.artifactProvider.provide(this.artifact.getId());
            }
            catch (Exception ex) {
                logger.debug("Unable to get artifact file for: " + this.artifact.getId(), (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    protected void analyze() throws IOException {
        String name = this.manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        if (name != null) {
            String version = this.manifest.getMainAttributes().getValue("Bundle-Version");
            if (version == null) {
                throw new IOException("Unable to get bundle version from artifact " + this.getArtifact().getId().toMvnId());
            }
            this.symbolicName = name;
            this.bundleVersion = version;
            String newBundleName = (String)this.getArtifact().getMetadata().get("bundle:rename-bsn");
            if (newBundleName != null) {
                this.symbolicName = newBundleName;
            }
            this.getExportedPackages().addAll(BundleDescriptorImpl.extractExportedPackages(this.manifest));
            this.getImportedPackages().addAll(BundleDescriptorImpl.extractImportedPackages(this.manifest));
            this.getDynamicImportedPackages().addAll(BundleDescriptorImpl.extractDynamicImportedPackages(this.manifest));
            try {
                ResourceImpl resource = ResourceBuilder.build(null, this.manifest.getMainAttributes().entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString())));
                this.getCapabilities().addAll(resource.getCapabilities(null));
                this.getRequirements().addAll(resource.getRequirements(null).stream().map(entry -> new MatchingRequirementImpl((Requirement)entry)).collect(Collectors.toList()));
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        } else {
            throw new IOException("Unable to get bundle symbolic name from artifact " + this.getArtifact().getId().toMvnId());
        }
    }

    public static List<PackageInfo> extractPackages(Manifest m, String headerName, String defaultVersion, boolean checkOptional) {
        String pckInfo = m.getMainAttributes().getValue(headerName);
        if (pckInfo != null) {
            Clause[] clauses = Parser.parseHeader(pckInfo);
            ArrayList<PackageInfo> pcks = new ArrayList<PackageInfo>();
            for (Clause entry : clauses) {
                String versionObj = entry.getAttribute("version");
                String version = versionObj == null ? defaultVersion : versionObj.toString();
                boolean optional = false;
                if (checkOptional) {
                    String resolution = entry.getDirective("resolution");
                    optional = "optional".equalsIgnoreCase(resolution);
                }
                HashSet<String> uses = new HashSet<String>();
                String usesAttribute = entry.getDirective("uses");
                if (usesAttribute != null && !usesAttribute.isEmpty()) {
                    StringTokenizer tokenizer = new StringTokenizer(usesAttribute, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String usePackage = tokenizer.nextToken();
                        uses.add(usePackage);
                    }
                }
                PackageInfo pck = new PackageInfo(entry.getName(), version, optional, uses);
                pcks.add(pck);
            }
            return pcks;
        }
        return Collections.emptyList();
    }

    public static List<PackageInfo> extractExportedPackages(Manifest m) {
        return BundleDescriptorImpl.extractPackages(m, "Export-Package", "0.0.0", false);
    }

    public static List<PackageInfo> extractImportedPackages(Manifest m) {
        return BundleDescriptorImpl.extractPackages(m, "Import-Package", null, true);
    }

    public static List<PackageInfo> extractDynamicImportedPackages(Manifest m) {
        return BundleDescriptorImpl.extractPackages(m, "DynamicImport-Package", null, false);
    }
}

