/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.scanner.ContainerDescriptor;
import org.apache.sling.feature.scanner.impl.ContentPackageDescriptor;
import org.apache.sling.feature.scanner.impl.ContentPackageScanner;
import org.apache.sling.feature.scanner.spi.ExtensionScanner;

public class ContentPackagesExtensionScanner
implements ExtensionScanner {
    @Override
    public String getId() {
        return "content-packages";
    }

    @Override
    public String getName() {
        return "Content Packages Scanner";
    }

    @Override
    public ContainerDescriptor scan(Feature feature, Extension extension, ArtifactProvider provider) throws IOException {
        if (!"content-packages".equals(extension.getName())) {
            return null;
        }
        if (extension.getType() != ExtensionType.ARTIFACTS) {
            return null;
        }
        ContentPackageScanner scanner = new ContentPackageScanner();
        ContainerDescriptor cd = new ContainerDescriptor(feature.getId().toMvnId() + "(" + this.getId() + ")"){};
        for (Artifact a : extension.getArtifacts()) {
            URL file = provider.provide(a.getId());
            if (file == null) {
                throw new IOException("Unable to find file for " + a.getId());
            }
            Set<ContentPackageDescriptor> pcks = scanner.scan(a, file);
            for (ContentPackageDescriptor desc : pcks) {
                cd.getArtifactDescriptors().add(desc);
                cd.getBundleDescriptors().addAll(desc.bundles);
            }
        }
        cd.lock();
        return cd;
    }
}

