/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.feature.MatchingRequirement;
import org.apache.sling.feature.scanner.PackageInfo;
import org.osgi.resource.Capability;

public abstract class Descriptor {
    private final String name;
    private boolean locked;
    private final Set<PackageInfo> exports = new HashSet<PackageInfo>();
    private final Set<PackageInfo> imports = new HashSet<PackageInfo>();
    private final Set<PackageInfo> dynImports = new HashSet<PackageInfo>();
    private final Set<MatchingRequirement> reqs = new HashSet<MatchingRequirement>();
    private final Set<Capability> caps = new HashSet<Capability>();

    protected Descriptor(String name) {
        this.name = name;
    }

    public void lock() {
        this.locked = true;
    }

    public final boolean isLocked() {
        return this.locked;
    }

    protected void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("Descriptor is locked.");
        }
    }

    protected void aggregate(Descriptor d) {
        this.reqs.addAll(d.getRequirements());
        this.caps.addAll(d.getCapabilities());
        this.dynImports.addAll(d.getDynamicImportedPackages());
        this.imports.addAll(d.getImportedPackages());
        this.exports.addAll(d.getExportedPackages());
    }

    public final Set<PackageInfo> getExportedPackages() {
        return this.locked ? Collections.unmodifiableSet(this.exports) : this.exports;
    }

    public final Set<PackageInfo> getImportedPackages() {
        return this.locked ? Collections.unmodifiableSet(this.imports) : this.imports;
    }

    public final Set<PackageInfo> getDynamicImportedPackages() {
        return this.locked ? Collections.unmodifiableSet(this.dynImports) : this.dynImports;
    }

    public String getName() {
        return this.name;
    }

    public final Set<MatchingRequirement> getRequirements() {
        return this.locked ? Collections.unmodifiableSet(this.reqs) : this.reqs;
    }

    public final Set<Capability> getCapabilities() {
        return this.locked ? Collections.unmodifiableSet(this.caps) : this.caps;
    }

    public String toString() {
        return this.name;
    }
}

