/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.Arrays;
import java.util.Collection;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;

public class CheckApisJarsProperties
implements AnalyserTask {
    private static final String SOURCE_IDS = "source-ids";

    @Override
    public String getId() {
        return "apis-jar";
    }

    @Override
    public String getName() {
        return "APIs jar properties check";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        ctx.getFeature().getBundles().getBundlesByStartOrder().values().stream().flatMap(Collection::stream).filter(artifact -> artifact.getMetadata().containsKey(SOURCE_IDS)).forEach(artifact -> this.checkSourceIdValidity((Artifact)artifact, ctx));
    }

    private void checkSourceIdValidity(Artifact a, AnalyserTaskContext ctx) {
        String sourceId = (String)a.getMetadata().get(SOURCE_IDS);
        Arrays.stream(sourceId.split(",")).map(String::trim).filter(el -> el.length() > 0).forEach(el -> {
            try {
                ArtifactId.parse((String)el);
            }
            catch (IllegalArgumentException e) {
                ctx.reportError("Bundle " + a.getId() + " has invalid sourceId entry '" + el + "' : " + e.getMessage());
            }
        });
    }
}

