/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyzer.impl.felix.utils.manifest.Parser;
import org.apache.sling.feature.analyzer.impl.felix.utils.resource.ResourceBuilder;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.apache.sling.feature.scanner.spi.FrameworkScanner;
import org.osgi.resource.Capability;

public class FelixFrameworkScanner
implements FrameworkScanner {
    private static final String DEFAULT_PROPERTIES = "default.properties";

    @Override
    public BundleDescriptor scan(final ArtifactId framework, Map<String, String> frameworkProps, ArtifactProvider provider) throws IOException {
        final URL platformFile = provider.provide(framework);
        if (platformFile == null) {
            throw new IOException("Unable to find file for " + framework.toMvnId());
        }
        Map<String, String> fwkProps = this.getFrameworkProperties(frameworkProps, platformFile);
        if (fwkProps == null) {
            return null;
        }
        Set<PackageInfo> pcks = this.calculateSystemPackages(fwkProps);
        List<Capability> capabilities = this.calculateSystemCapabilities(fwkProps);
        BundleDescriptor d = new BundleDescriptor(framework.toMvnId()){

            @Override
            public String getBundleSymbolicName() {
                return "system.bundle";
            }

            @Override
            public String getBundleVersion() {
                return framework.getOSGiVersion().toString();
            }

            @Override
            public int getBundleStartLevel() {
                return 0;
            }

            @Override
            public URL getArtifactFile() {
                return platformFile;
            }

            @Override
            public Artifact getArtifact() {
                return new Artifact(framework);
            }

            @Override
            public Manifest getManifest() {
                return new Manifest();
            }
        };
        d.getCapabilities().addAll(capabilities);
        d.getExportedPackages().addAll(pcks);
        d.lock();
        return d;
    }

    private List<Capability> calculateSystemCapabilities(Map<String, String> fwkProps) throws IOException {
        HashMap<String, String> mf = new HashMap<String, String>();
        mf.put("Provide-Capability", Stream.of(fwkProps.get("org.osgi.framework.system.capabilities"), fwkProps.get("org.osgi.framework.system.capabilities.extra")).filter(Objects::nonNull).collect(Collectors.joining(",")));
        mf.put("Bundle-SymbolicName", "system.bundle");
        mf.put("Bundle-ManifestVersion", "2");
        try {
            return ResourceBuilder.build(null, mf).getCapabilities(null);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private Set<PackageInfo> calculateSystemPackages(Map<String, String> fwkProps) {
        return Stream.of(Parser.parseHeader(Stream.of(fwkProps.get("org.osgi.framework.system.packages"), fwkProps.get("org.osgi.framework.system.packages.extra")).filter(Objects::nonNull).collect(Collectors.joining(",")))).map(clause -> new PackageInfo(clause.getName(), clause.getAttribute("version") != null ? clause.getAttribute("version") : "0.0.0", false)).collect(Collectors.toSet());
    }

    Map<String, String> getFrameworkProperties(Map<String, String> appProps, URL framework) throws IOException {
        HashMap<String, Properties> propsMap = new HashMap<String, Properties>();
        try (JarFile zipFile = IOUtils.getJarFileFromURL((URL)framework, (boolean)true, null);){
            Enumeration<JarEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream inputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".properties")) continue;
                    Properties props = new Properties();
                    props.load(inputStream);
                    propsMap.put(entryName, props);
                }
                catch (Throwable entryName) {
                    throwable = entryName;
                    throw entryName;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable entryName) {
                            throwable.addSuppressed(entryName);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        final Properties defaultMap = (Properties)propsMap.get(DEFAULT_PROPERTIES);
        if (defaultMap == null) {
            return null;
        }
        final HashMap<String, String> frameworkProps = new HashMap<String, String>();
        appProps.forEach((key, value) -> frameworkProps.put((String)key, value.replace("{dollar}", "$")));
        defaultMap.put("java.specification.version", "1.8");
        defaultMap.put("felix.detect.java.specification.version", "1.8");
        defaultMap.put("felix.detect.java.version", "0.0.0.JavaSE_018");
        StringSubstitutor ss = new StringSubstitutor(new StringLookup(){

            public String lookup(String key) {
                String val = defaultMap.getProperty(key);
                return val != null ? val : "";
            }
        });
        ss.setEnableSubstitutionInVariables(true);
        for (Object object : defaultMap.keySet()) {
            if (frameworkProps.get(object.toString()) != null) continue;
            String value2 = (String)defaultMap.get(object);
            String substValue = ss.replace(value2);
            frameworkProps.put(object.toString(), substValue);
        }
        ss = new StringSubstitutor(new StringLookup(){

            public String lookup(String key) {
                String val = (String)frameworkProps.get(key);
                return val != null ? val.replace("{dollar}", "$") : "";
            }
        });
        ss.setEnableSubstitutionInVariables(true);
        for (Map.Entry entry : frameworkProps.entrySet()) {
            entry.setValue(ss.replace(((String)entry.getValue()).replace("{dollar}", "$")));
        }
        return frameworkProps;
    }
}

