/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class ListExportedPackages
implements AnalyserTask {
    @Override
    public String getId() {
        return "exported-packages";
    }

    @Override
    public String getName() {
        return "List exported packages check";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        TreeSet<String> packages = new TreeSet<String>();
        for (BundleDescriptor bd : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            for (PackageInfo p : bd.getExportedPackages()) {
                packages.add(p.getName());
            }
        }
        File f = new File("packages.txt");
        if (f.exists()) {
            throw new IOException("File " + f.getAbsolutePath() + " already exists. This plugin does not overwrite an existing file");
        }
        FileWriter fw = new FileWriter(f);
        Object object = null;
        try {
            for (String p : packages) {
                fw.write(p);
                fw.write(System.getProperty("line.separator"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fw != null) {
                if (object != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fw.close();
                }
            }
        }
        ctx.reportWarning("Finished writing exported packages to " + f.getAbsolutePath());
    }
}

