/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyzer.impl.felix.utils.resource.CapabilitySet;
import org.apache.sling.feature.analyzer.impl.felix.utils.resource.RequirementImpl;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.Descriptor;
import org.osgi.resource.Requirement;

public class CheckRequirementsCapabilities
implements AnalyserTask {
    private final String format = "Artifact %s requires %s in start level %d but %s";

    @Override
    public String getId() {
        return "requirements-capabilities";
    }

    @Override
    public String getName() {
        return "Requirements Capabilities check";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        TreeMap<Integer, List<Descriptor>> artifactsMap = new TreeMap<Integer, List<Descriptor>>();
        for (BundleDescriptor bi : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            List<Descriptor> list = this.getDescriptorList(bi.getArtifact().getStartOrder(), artifactsMap);
            list.add(bi);
        }
        if (!ctx.getFeatureDescriptor().getArtifactDescriptors().isEmpty()) {
            artifactsMap.put((artifactsMap.isEmpty() ? 0 : (Integer)artifactsMap.lastKey()) + 1, new ArrayList<ArtifactDescriptor>(ctx.getFeatureDescriptor().getArtifactDescriptors()));
        }
        String featureMavenID = ctx.getFeature().getId().toMvnId();
        ReqCapDescriptor featureCaps = new ReqCapDescriptor(featureMavenID);
        featureCaps.getCapabilities().addAll(ctx.getFeature().getCapabilities());
        this.getDescriptorList(0, artifactsMap).add(featureCaps);
        ReqCapDescriptor featureReqs = new ReqCapDescriptor(featureMavenID);
        featureReqs.getRequirements().addAll(ctx.getFeature().getRequirements());
        Integer highestStartLevel = (Integer)artifactsMap.lastKey();
        this.getDescriptorList(highestStartLevel, artifactsMap).add(featureReqs);
        ArrayList<Descriptor> artifacts = new ArrayList<Descriptor>();
        if (ctx.getFrameworkDescriptor() != null) {
            artifacts.add(ctx.getFrameworkDescriptor());
        }
        boolean errorReported = false;
        for (Map.Entry entry : artifactsMap.entrySet()) {
            for (Descriptor info : (List)entry.getValue()) {
                if (info.getCapabilities() == null) continue;
                artifacts.add(info);
            }
            for (Descriptor info : (List)entry.getValue()) {
                if (info.getRequirements() == null) continue;
                for (Requirement requirement : info.getRequirements()) {
                    String ns = requirement.getNamespace();
                    if ("osgi.wiring.package".equals(ns) || "osgi.service".equals(ns)) continue;
                    List<Descriptor> candidates = this.getCandidates(artifacts, requirement);
                    if (candidates.isEmpty()) {
                        if (!RequirementImpl.isOptional(requirement)) {
                            ctx.reportError(String.format("Artifact %s requires %s in start level %d but %s", info.getName(), requirement.toString(), entry.getKey(), "no artifact is providing a matching capability in this start level."));
                            errorReported = true;
                            continue;
                        }
                        ctx.reportWarning(String.format("Artifact %s requires %s in start level %d but %s", info.getName(), requirement.toString(), entry.getKey(), "while the requirement is optional no artifact is providing a matching capability in this start level."));
                        continue;
                    }
                    if (candidates.size() <= 1) continue;
                    ctx.reportWarning(String.format("Artifact %s requires %s in start level %d but %s", info.getName(), requirement.toString(), entry.getKey(), "there is more than one matching capability in this start level: " + candidates));
                }
            }
        }
        if (errorReported && ctx.getFeature().isComplete()) {
            ctx.reportError(ctx.getFeature().getId().toMvnId() + " is marked as 'complete' but has unsatisfied requirements.");
        }
    }

    private List<Descriptor> getDescriptorList(int sl, SortedMap<Integer, List<Descriptor>> artifactsMap) {
        ArrayList list = (ArrayList)artifactsMap.get(sl);
        if (list == null) {
            list = new ArrayList();
            artifactsMap.put(sl, list);
        }
        return list;
    }

    private List<Descriptor> getCandidates(List<Descriptor> artifactDescriptors, Requirement requirement) {
        return artifactDescriptors.stream().filter(artifactDescriptor -> artifactDescriptor.getCapabilities() != null).filter(artifactDescriptor -> artifactDescriptor.getCapabilities().stream().anyMatch(capability -> CapabilitySet.matches(capability, requirement))).collect(Collectors.toList());
    }

    static class ReqCapDescriptor
    extends Descriptor {
        protected ReqCapDescriptor(String name) {
            super(name);
        }
    }
}

